/*
 * Decompiled with CFR 0.152.
 */
package org.loom.test;

import java.util.Set;
import org.loom.action.Action;
import org.loom.annotation.processor.AbstractInterceptorAnnotationProcessor;
import org.loom.annotation.processor.AnnotationProcessor;
import org.loom.annotation.processor.metadata.AnnotationMetadataFactory;
import org.loom.binding.PropertyBinderFactory;
import org.loom.interceptor.Interceptor;
import org.loom.interceptor.InterceptorFactory;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.ActionMappingFactory;
import org.loom.mapping.Event;
import org.loom.mapping.RestActionMappingFactory;
import org.loom.mock.MockInterceptorFactory;
import org.loom.util.TestUtil;
import org.loom.validator.PropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationProcessorTests<T extends AnnotationProcessor> {
    protected T processor;
    protected ActionMapping mapping;
    private ActionMappingFactory factory;
    private Class<? extends Action> actionClass;
    private AnnotationMetadataFactory metadataFactory = new AnnotationMetadataFactory();
    private PropertyBinderFactory propertyBinderFactory = new PropertyBinderFactory();

    public void init(Class<? extends Action> actionClass) {
        TestUtil.initConfig();
        this.actionClass = actionClass;
        if (this.processor instanceof AbstractInterceptorAnnotationProcessor) {
            ((AbstractInterceptorAnnotationProcessor)this.processor).setInterceptorFactory((InterceptorFactory)new MockInterceptorFactory());
        }
        this.mapping = new ActionMapping();
        this.mapping.setHandle("my");
        this.mapping.setActionClass(actionClass);
        this.mapping.setPropertyBinderMap(this.propertyBinderFactory.createPropertyBinderMap(actionClass));
        this.factory = new RestActionMappingFactory();
        this.factory.initEvents(this.mapping);
    }

    protected <V extends PropertyValidator> V getValidator(Event event, String propertyPath, Class<V> validatorClass) {
        for (PropertyValidator v : event.getValidatorsForProperty(propertyPath)) {
            if (!validatorClass.isAssignableFrom(v.getClass())) continue;
            return (V)v;
        }
        return null;
    }

    protected <I extends Interceptor> I getInterceptor(Event event, Class<I> interceptorClass) {
        Set l = event.getInterceptors().findInterceptorsWithClass(interceptorClass);
        return (I)(l.isEmpty() ? null : (Interceptor)l.iterator().next());
    }

    protected void processAnnotations() {
        this.processor.process(this.metadataFactory.create(this.actionClass), this.mapping);
    }
}

