/*
 * Decompiled with CFR 0.152.
 */
package org.loom.test;

import java.util.Comparator;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.loom.config.Config;
import org.loom.converter.Converter;
import org.loom.i18n.Message;
import org.loom.i18n.Messages;
import org.loom.i18n.MessagesRepository;
import org.loom.i18n.MessagesRepositoryFactory;
import org.loom.log.Log;
import org.loom.servlet.params.ParameterValue;
import org.loom.servlet.params.StringParameterValue;
import org.loom.util.TestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConverterTests<T extends Converter> {
    protected T converter;
    protected MessagesRepositoryFactory messagesRepositoryFactory;
    protected static Locale SPANISH = new Locale("es");
    private static Log log = Log.getLog();

    @Before
    public final void initConfig() {
        TestUtil.initConfig();
        this.messagesRepositoryFactory = Config.getInstance().getMessagesRepositoryFactory();
    }

    protected void assertConvertedText(String valueAsString, Object valueAsObject, Locale locale) {
        this.assertConvertedText(valueAsString, valueAsObject, locale, null);
    }

    protected void assertConvertedText(String valueAsString, Object valueAsObject, Locale locale, Comparator comparator) {
        log.info(new Object[]{"Converting to text ", valueAsObject, " (actual) -> ", valueAsString, " (expected), locale ", locale});
        MessagesRepository repository = this.messagesRepositoryFactory.getRepository(locale);
        String actualText = this.converter.getAsText(valueAsObject, repository);
        Assert.assertEquals((Object)valueAsString, (Object)actualText);
        log.info(new Object[]{"Converting back to object ", actualText});
        Messages messages = new Messages();
        Object convertedValue = this.converter.getAsObject((ParameterValue)new StringParameterValue("kk", actualText), messages, repository);
        if (comparator == null) {
            Assert.assertEquals((Object)valueAsObject, (Object)convertedValue);
        } else {
            Assert.assertEquals((String)"Original and converted values are not equal", (long)0L, (long)comparator.compare(valueAsObject, convertedValue));
        }
        if (messages.size() > 0) {
            log.info(new Object[]{TestUtil.toString(messages)});
            Assert.fail((String)("There have been errors trying to convert " + valueAsString));
        }
    }

    protected void assertConversionFails(String text, Locale locale) {
        log.info(new Object[]{"Checking that conversion fails for ", text});
        MessagesRepository repository = this.messagesRepositoryFactory.getRepository(locale);
        Messages messages = new Messages();
        Object convertedValue = this.converter.getAsObject((ParameterValue)new StringParameterValue("kk", text), messages, repository);
        Assert.assertNull((String)("Expected null, but instead: " + convertedValue), (Object)convertedValue);
        Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0);
        log.info(new Object[]{repository.translateMessage((Message)messages.getAllMessages().get(0))});
    }

    protected void assertReturnValue(String string, Class expectedClass) {
        MessagesRepository repository = this.messagesRepositoryFactory.getRepository(SPANISH);
        Messages messages = new Messages();
        Object convertedValue = this.converter.getAsObject((ParameterValue)new StringParameterValue("kk", string), messages, repository);
        Assert.assertNotNull((Object)convertedValue);
        Assert.assertTrue((boolean)expectedClass.isAssignableFrom(convertedValue.getClass()));
    }

    @Test
    public void testNullOrEmptyValue() {
        MessagesRepository repository = this.messagesRepositoryFactory.getRepository(SPANISH);
        Messages messages = new Messages();
        Assert.assertNull((Object)this.converter.getAsObject((ParameterValue)new StringParameterValue("kk", ""), messages, repository));
        Assert.assertTrue((String)TestUtil.toString(messages), (messages.size() == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.converter.getAsObject((ParameterValue)new StringParameterValue("kk", null), messages, repository));
        Assert.assertTrue((String)TestUtil.toString(messages), (messages.size() == 0 ? 1 : 0) != 0);
        String s = this.converter.getAsText(null, repository);
        Assert.assertTrue((s == null || s.length() == 0 ? 1 : 0) != 0);
    }
}

