/*
 * Decompiled with CFR 0.152.
 */
package org.loom.test;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.loom.log.Log;
import org.loom.util.ClassUtils;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@Transactional
public abstract class AbstractHibernateTests
extends AbstractTransactionalDataSourceSpringContextTests {
    private static Log log = Log.getLog();
    @PersistenceContext
    private EntityManager entityManager;

    public AbstractHibernateTests() {
        this.setDefaultRollback(false);
    }

    @Test
    public void testColumnMapping() throws Exception {
        Session session = (Session)this.entityManager.getDelegate();
        Map metadata = session.getSessionFactory().getAllClassMetadata();
        int count = 0;
        for (EntityPersister persister : metadata.values()) {
            String className = persister.getEntityName();
            if (ClassUtils.isAbstract((Class)ClassUtils.forName((String)className))) {
                log.info(new Object[]{"Skipping abstract class ", className});
                continue;
            }
            log.info(new Object[]{"select * from ", className});
            Query q = session.createQuery("from " + className);
            q.iterate();
            log.info(new Object[]{"ok"});
            ++count;
        }
        AbstractHibernateTests.assertTrue((String)"No persistent classes found", (count > 0 ? 1 : 0) != 0);
        Thread.sleep(10L);
    }
}

