/*
 * Decompiled with CFR 0.152.
 */
package org.loom.test;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import junit.framework.ComparisonFailure;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.loom.action.Action;
import org.loom.action.ActionContext;
import org.loom.config.Config;
import org.loom.log.Log;
import org.loom.mapping.ActionMapping;
import org.loom.mapping.ActionMappingRepository;
import org.loom.mock.MockJspFragment;
import org.loom.mock.MockJspWriter;
import org.loom.mock.MockPageContext;
import org.loom.mock.MockResolutionFactory;
import org.loom.resolution.ResolutionFactory;
import org.loom.servlet.LoomServletRequest;
import org.loom.servlet.LoomServletRequestImpl;
import org.loom.servlet.LoomServletResponse;
import org.loom.servlet.LoomServletResponseImpl;
import org.loom.util.TestUtil;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequestTests {
    protected MockServletContext servletContext;
    protected MockHttpServletResponse mockResponse;
    protected MockHttpServletRequest mockRequest;
    protected Config config;
    protected LoomServletRequestImpl request;
    protected LoomServletResponseImpl response;
    protected ActionContext actionContext;
    protected MockPageContext pageContext;
    protected MockJspFragment body;
    protected static Log log = Log.getLog();

    @Before
    public final void initRequest() {
        TestUtil.initConfig();
        this.config = Config.getInstance();
        this.servletContext = (MockServletContext)this.config.getServletContext();
        this.config.setServletContext((ServletContext)this.servletContext);
        this.mockRequest = new MockHttpServletRequest((ServletContext)this.servletContext, "GET", "/webcontext/jspPage.jsp");
        this.mockRequest.setContextPath("/webcontext");
        this.mockResponse = new MockHttpServletResponse();
        this.request = LoomServletRequestImpl.getOrCreateInstance((ServletRequest)this.mockRequest);
        LoomServletRequestImpl.setThreadLocal((LoomServletRequest)this.request);
        this.response = LoomServletResponseImpl.getInstance((LoomServletRequest)this.request, (HttpServletResponse)this.mockResponse);
        this.actionContext = new ActionContext();
        this.actionContext.setRequest((LoomServletRequest)this.request);
        this.actionContext.setResponse((LoomServletResponse)this.response);
        this.actionContext.setResolutionFactory((ResolutionFactory)new MockResolutionFactory());
        this.pageContext = new MockPageContext((ServletContext)this.servletContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        this.body = new MockJspFragment((JspContext)this.pageContext);
    }

    protected ActionMapping addActionMapping(Class<? extends Action> actionClass) {
        ActionMappingRepository repository = this.config.getActionMappingRepository();
        return repository.addActionMapping(actionClass);
    }

    @After
    public void flushOutput() throws IOException {
        if (this.pageContext != null) {
            this.pageContext.getOut().flush();
        }
    }

    protected void assertContains(String text) {
        if (!this.getOutput().contains(text)) {
            throw new ComparisonFailure("Expected text not found", text, this.getOutput());
        }
    }

    protected void assertNotContains(String text) {
        if (this.getOutput().contains(text)) {
            throw new ComparisonFailure("Unexpected text found in output", text, this.getOutput());
        }
    }

    protected void assertOutput(String text) {
        Assert.assertEquals((Object)text, (Object)this.getOutput());
    }

    protected void assertAttribute(String name, Object value) {
        this.assertContains(name + "=\"" + value + "\"");
    }

    protected void assertAttributePresent(String name) {
        this.assertContains(name + "=\"");
    }

    protected void assertAttributeMissing(String name) {
        this.assertNotContains(name + "=\"");
    }

    protected String getOutput() {
        return ((MockJspWriter)this.pageContext.getOut()).toString();
    }

    protected MockHttpServletRequest getMockRequest() {
        LoomServletRequestImpl req = this.request;
        return (MockHttpServletRequest)req.getRequest();
    }
}

