/*
 * Decompiled with CFR 0.152.
 */
package org.loom.test;

import org.junit.Assert;
import org.junit.Before;
import org.loom.config.Config;
import org.loom.i18n.Messages;
import org.loom.log.Log;
import org.loom.util.TestUtil;
import org.loom.validator.PropertyValidator;
import org.loom.validator.ValidationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatorTests<T extends PropertyValidator> {
    protected T validator;
    private Log log = Log.getLog();

    @Before
    public final void initConfig() {
        TestUtil.initConfig();
    }

    protected void assertPass(Object value) {
        Messages e = new Messages();
        this.validator.validate(new ValidationRequest(this.validator, e), value);
        Assert.assertTrue((String)(Config.getInstance() == null ? null : TestUtil.toString(e)), (boolean)e.isEmpty());
        this.log.info(new Object[]{"Validation pass (", value, ")"});
    }

    protected void assertFail(Object value) {
        Messages e = new Messages();
        this.validator.validate(new ValidationRequest(this.validator, e), value);
        Assert.assertFalse((boolean)e.isEmpty());
        this.log.info(new Object[]{"Validation fail (", value, "): ", TestUtil.toString(e)});
    }
}

