/*
 * Decompiled with CFR 0.152.
 */
package org.loom.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.loom.config.ActionScanner;
import org.loom.config.Config;
import org.loom.config.ResourcesWatchdog;
import org.loom.i18n.Message;
import org.loom.i18n.Messages;
import org.loom.i18n.MessagesRepository;
import org.loom.i18n.MessagesRepositoryFactoryImpl;
import org.loom.injection.DependencyInjectionAdapter;
import org.loom.mock.MockDependencyInjectionAdapter;
import org.loom.mock.MockResourcesWatchdog;
import org.springframework.mock.web.MockServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil {
    public static String toString(Messages messages) {
        MessagesRepository repository = Config.getInstance().getMessagesRepositoryFactory().getRepository(Locale.getDefault());
        StringBuilder builder = new StringBuilder();
        for (Message m : messages.getAllMessages()) {
            builder.append(repository.translateMessage(m)).append("\n");
        }
        return builder.toString();
    }

    public static <T extends Serializable> T serializeAndDeserialize(T instance) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(instance);
        byte[] serialized = bos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
        ObjectInputStream input = new ObjectInputStream(bis);
        Serializable deserialized = (Serializable)input.readObject();
        return (T)deserialized;
    }

    public static void initConfig() {
        if (Config.getInstance() == null) {
            Config config = new Config();
            Config.setInstance((Config)config);
            config.setServletContext((ServletContext)new MockServletContext());
            ActionScanner scanner = new ActionScanner();
            scanner.setActionPackages(new String[]{"org.loom.action"});
            config.setActionScanner(scanner);
            config.setDependencyInjectionAdapter((DependencyInjectionAdapter)new MockDependencyInjectionAdapter());
            config.setResourcesWatchdog((ResourcesWatchdog)new MockResourcesWatchdog());
            config.validate();
            config.scanAndConfigureActions();
            MessagesRepositoryFactoryImpl factory = (MessagesRepositoryFactoryImpl)config.getMessagesRepositoryFactory();
            factory.setDefaultLocale(Locale.ENGLISH);
            factory.setLocations(Arrays.asList("classpath:resources/loom-messages", "classpath:resources/messages"));
        }
    }
}

