/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.ognl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.ezlibs.shaded.ognl.NodeType;
import org.ezlibs.shaded.ognl.OgnlContext;
import org.ezlibs.shaded.ognl.OgnlException;
import org.ezlibs.shaded.ognl.OgnlOps;
import org.ezlibs.shaded.ognl.OgnlParser;
import org.ezlibs.shaded.ognl.OgnlRuntime;
import org.ezlibs.shaded.ognl.SimpleNode;

public class ASTStaticField
extends SimpleNode
implements NodeType {
    private String className;
    private String fieldName;
    private Class _getterClass;

    public ASTStaticField(int id) {
        super(id);
    }

    public ASTStaticField(OgnlParser p, int id) {
        super(p, id);
    }

    void init(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        return OgnlRuntime.getStaticField(context, this.className, this.fieldName);
    }

    @Override
    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        Exception reason;
        boolean result;
        block10: {
            result = false;
            reason = null;
            try {
                Field f;
                block11: {
                    Class c = OgnlRuntime.classForName(context, this.className);
                    if (this.fieldName.equals("class")) {
                        result = true;
                        break block10;
                    }
                    if (OgnlRuntime.isJdk15() && c.isEnum()) {
                        result = true;
                        break block10;
                    }
                    try {
                        f = c.getField(this.fieldName);
                    }
                    catch (NoSuchFieldException nsfe) {
                        f = OgnlRuntime.getField(c, this.fieldName);
                        if (f != null) break block11;
                        throw new NoSuchFieldException(this.fieldName);
                    }
                }
                int fModifiers = f.getModifiers();
                if (!Modifier.isStatic(fModifiers)) {
                    throw new OgnlException("Field " + this.fieldName + " of class " + this.className + " is not static");
                }
                result = Modifier.isFinal(fModifiers);
            }
            catch (ClassNotFoundException e) {
                reason = e;
            }
            catch (NoSuchFieldException e) {
                reason = e;
            }
            catch (SecurityException e) {
                reason = e;
            }
        }
        if (reason != null) {
            throw new OgnlException("Could not get static field " + this.fieldName + " from class " + this.className, reason);
        }
        return result;
    }

    Class getFieldClass(OgnlContext context) throws OgnlException {
        Exception reason = null;
        try {
            Class c = OgnlRuntime.classForName(context, this.className);
            if (this.fieldName.equals("class")) {
                return c;
            }
            if (OgnlRuntime.isJdk15() && c.isEnum()) {
                return c;
            }
            Field f = c.getField(this.fieldName);
            return f.getType();
        }
        catch (ClassNotFoundException e) {
            reason = e;
        }
        catch (NoSuchFieldException e) {
            reason = e;
        }
        catch (SecurityException e) {
            reason = e;
        }
        if (reason != null) {
            throw new OgnlException("Could not get static field " + this.fieldName + " from class " + this.className, reason);
        }
        return null;
    }

    @Override
    public Class getGetterClass() {
        return this._getterClass;
    }

    @Override
    public Class getSetterClass() {
        return this._getterClass;
    }

    @Override
    public String toString() {
        return "@" + this.className + "@" + this.fieldName;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        try {
            Object obj = OgnlRuntime.getStaticField(context, this.className, this.fieldName);
            context.setCurrentObject(obj);
            this._getterClass = this.getFieldClass(context);
            context.setCurrentType(this._getterClass);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return this.className + "." + this.fieldName;
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        try {
            Object obj = OgnlRuntime.getStaticField(context, this.className, this.fieldName);
            context.setCurrentObject(obj);
            this._getterClass = this.getFieldClass(context);
            context.setCurrentType(this._getterClass);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return this.className + "." + this.fieldName;
    }
}

