/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ezlibs.shaded.org.attoparser.HtmlElement;
import org.ezlibs.shaded.org.attoparser.HtmlElements;

final class HtmlNames {
    static final Set<String> ALL_STANDARD_ELEMENT_NAMES;
    static final Set<String> ALL_STANDARD_ATTRIBUTE_NAMES;

    private HtmlNames() {
    }

    static {
        ArrayList<String> allStandardElementNamesAux = new ArrayList<String>(HtmlElements.ALL_STANDARD_ELEMENTS.size() + 3);
        for (HtmlElement element : HtmlElements.ALL_STANDARD_ELEMENTS) {
            allStandardElementNamesAux.add(new String(element.name));
        }
        Collections.sort(allStandardElementNamesAux);
        ALL_STANDARD_ELEMENT_NAMES = Collections.unmodifiableSet(new LinkedHashSet(allStandardElementNamesAux));
        ArrayList<String> allStandardAttributeNamesAux = new ArrayList<String>(Arrays.asList("abbr", "accept", "accept-charset", "accesskey", "action", "align", "alt", "archive", "autocomplete", "autofocus", "autoplay", "axis", "border", "cellpadding", "cellspacing", "challenge", "char", "charoff", "charset", "checked", "cite", "class", "classid", "codebase", "codetype", "cols", "colspan", "command", "content", "contenteditable", "contextmenu", "controls", "coords", "data", "datetime", "declare", "default", "defer", "dir", "disabled", "draggable", "dropzone", "enctype", "for", "form", "formaction", "formenctype", "formmethod", "formnovalidate", "formtarget", "frame", "headers", "height", "hidden", "high", "href", "hreflang", "http-equiv", "icon", "id", "ismap", "keytype", "kind", "label", "lang", "list", "longdesc", "loop", "low", "max", "maxlength", "media", "method", "min", "multiple", "muted", "name", "nohref", "novalidate", "onabort", "onafterprint", "onbeforeprint", "onbeforeunload", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "oncuechange", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "onformchange", "onforminput", "onhaschange", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmessage", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onoffline", "ononline", "onpagehide", "onpageshow", "onpause", "onplay", "onplaying", "onpopstate", "onprogress", "onratechange", "onredo", "onreset", "onresize", "onscroll", "onseeked", "onseeking", "onselect", "onstalled", "onstorage", "onsubmit", "onsuspend", "ontimeupdate", "onundo", "onunload", "onvolumechange", "onwaiting", "open", "optimum", "pattern", "placeholder", "poster", "preload", "profile", "radiogroup", "readonly", "rel", "required", "rev", "rows", "rowspan", "rules", "scheme", "scope", "selected", "shape", "size", "span", "spellcheck", "src", "srclang", "standby", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "valuetype", "width", "xml:lang", "xml:space", "xmlns"));
        Collections.sort(allStandardAttributeNamesAux);
        ALL_STANDARD_ATTRIBUTE_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(allStandardAttributeNamesAux));
    }
}

