/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -7951733720511589140L;
    private final Integer line;
    private final Integer col;

    public ParseException() {
        this.line = null;
        this.col = null;
    }

    public ParseException(String message, Throwable throwable) {
        super(ParseException.message(message, throwable), throwable);
        if (throwable != null && throwable instanceof ParseException) {
            this.line = ((ParseException)throwable).getLine();
            this.col = ((ParseException)throwable).getCol();
        } else {
            this.line = null;
            this.col = null;
        }
    }

    public ParseException(String message) {
        super(message);
        this.line = null;
        this.col = null;
    }

    public ParseException(Throwable throwable) {
        super(ParseException.message(null, throwable), throwable);
        if (throwable != null && throwable instanceof ParseException) {
            this.line = ((ParseException)throwable).getLine();
            this.col = ((ParseException)throwable).getCol();
        } else {
            this.line = null;
            this.col = null;
        }
    }

    public ParseException(int line, int col) {
        super(ParseException.messagePrefix(line, col));
        this.line = line;
        this.col = col;
    }

    public ParseException(String message, Throwable throwable, int line, int col) {
        super(ParseException.messagePrefix(line, col) + " " + message, throwable);
        this.line = line;
        this.col = col;
    }

    public ParseException(String message, int line, int col) {
        super(ParseException.messagePrefix(line, col) + " " + message);
        this.line = line;
        this.col = col;
    }

    public ParseException(Throwable throwable, int line, int col) {
        super(ParseException.messagePrefix(line, col), throwable);
        this.line = line;
        this.col = col;
    }

    private static String messagePrefix(int line, int col) {
        return "(Line = " + line + ", Column = " + col + ")";
    }

    private static String message(String message, Throwable throwable) {
        ParseException exception;
        if (throwable != null && throwable instanceof ParseException && (exception = (ParseException)throwable).getLine() != null && exception.getCol() != null) {
            return "(Line = " + exception.getLine() + ", Column = " + exception.getCol() + ")" + (message != null ? " " + message : throwable.getMessage());
        }
        if (message != null) {
            return message;
        }
        if (throwable != null) {
            return throwable.getMessage();
        }
        return null;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getCol() {
        return this.col;
    }
}

