/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser.output;

import java.io.Writer;
import org.ezlibs.shaded.org.attoparser.AbstractMarkupHandler;
import org.ezlibs.shaded.org.attoparser.ParseException;

public final class OutputMarkupHandler
extends AbstractMarkupHandler {
    private final Writer writer;

    public OutputMarkupHandler(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null");
        }
        this.writer = writer;
    }

    @Override
    public void handleText(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        try {
            this.writer.write(buffer, offset, len);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleComment(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        try {
            this.writer.write(buffer, outerOffset, outerLen);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleCDATASection(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        try {
            this.writer.write(buffer, outerOffset, outerLen);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int offset, int len, boolean minimized, int line, int col) throws ParseException {
        try {
            this.writer.write(60);
            this.writer.write(buffer, offset, len);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleStandaloneElementEnd(char[] buffer, int offset, int len, boolean minimized, int line, int col) throws ParseException {
        try {
            if (minimized) {
                this.writer.write(47);
            }
            this.writer.write(62);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        try {
            this.writer.write(60);
            this.writer.write(buffer, offset, len);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleOpenElementEnd(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        try {
            this.writer.write(62);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleAutoOpenElementStart(char[] buffer, int offset, int len, int line, int col) throws ParseException {
    }

    @Override
    public void handleAutoOpenElementEnd(char[] buffer, int offset, int len, int line, int col) throws ParseException {
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        try {
            this.writer.write("</");
            this.writer.write(buffer, offset, len);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleCloseElementEnd(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        try {
            this.writer.write(62);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleAutoCloseElementStart(char[] buffer, int offset, int len, int line, int col) throws ParseException {
    }

    @Override
    public void handleAutoCloseElementEnd(char[] buffer, int offset, int len, int line, int col) throws ParseException {
    }

    @Override
    public void handleUnmatchedCloseElementStart(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.handleCloseElementStart(buffer, offset, len, line, col);
    }

    @Override
    public void handleUnmatchedCloseElementEnd(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        this.handleCloseElementEnd(buffer, offset, len, line, col);
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        try {
            this.writer.write(buffer, nameOffset, nameLen);
            this.writer.write(buffer, operatorOffset, operatorLen);
            this.writer.write(buffer, valueOuterOffset, valueOuterLen);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleInnerWhiteSpace(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        try {
            this.writer.write(buffer, offset, len);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleDocType(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int elementNameOffset, int elementNameLen, int elementNameLine, int elementNameCol, int typeOffset, int typeLen, int typeLine, int typeCol, int publicIdOffset, int publicIdLen, int publicIdLine, int publicIdCol, int systemIdOffset, int systemIdLen, int systemIdLine, int systemIdCol, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, int outerOffset, int outerLen, int outerLine, int outerCol) throws ParseException {
        try {
            this.writer.write(buffer, outerOffset, outerLen);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleXmlDeclaration(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int versionOffset, int versionLen, int versionLine, int versionCol, int encodingOffset, int encodingLen, int encodingLine, int encodingCol, int standaloneOffset, int standaloneLen, int standaloneLine, int standaloneCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        try {
            this.writer.write(buffer, outerOffset, outerLen);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    @Override
    public void handleProcessingInstruction(char[] buffer, int targetOffset, int targetLen, int targetLine, int targetCol, int contentOffset, int contentLen, int contentLine, int contentCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        try {
            this.writer.write(buffer, outerOffset, outerLen);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

