/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ezlibs.shaded.org.thymeleaf.DialectConfiguration;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.dialect.IDialect;
import org.ezlibs.shaded.org.thymeleaf.dialect.IExecutionAttributeDialect;
import org.ezlibs.shaded.org.thymeleaf.dialect.IExpressionObjectDialect;
import org.ezlibs.shaded.org.thymeleaf.dialect.IPostProcessorDialect;
import org.ezlibs.shaded.org.thymeleaf.dialect.IPreProcessorDialect;
import org.ezlibs.shaded.org.thymeleaf.dialect.IProcessorDialect;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.ElementDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.ezlibs.shaded.org.thymeleaf.engine.IElementDefinitionsAware;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.exceptions.ConfigurationException;
import org.ezlibs.shaded.org.thymeleaf.expression.IExpressionObjectFactory;
import org.ezlibs.shaded.org.thymeleaf.postprocessor.IPostProcessor;
import org.ezlibs.shaded.org.thymeleaf.preprocessor.IPreProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.IProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.cdatasection.ICDATASectionProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.comment.ICommentProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.doctype.IDocTypeProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.processinginstruction.IProcessingInstructionProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.templateboundaries.ITemplateBoundariesProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.text.ITextProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.xmldeclaration.IXMLDeclarationProcessor;
import org.ezlibs.shaded.org.thymeleaf.standard.StandardDialect;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.ProcessorComparators;
import org.ezlibs.shaded.org.thymeleaf.util.ProcessorConfigurationUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

final class DialectSetConfiguration {
    private final Set<DialectConfiguration> dialectConfigurations;
    private final Set<IDialect> dialects;
    private final boolean standardDialectPresent;
    private final String standardDialectPrefix;
    private final Map<String, Object> executionAttributes;
    private final AggregateExpressionObjectFactory expressionObjectFactory;
    private final ElementDefinitions elementDefinitions;
    private final AttributeDefinitions attributeDefinitions;
    private final EnumMap<TemplateMode, Set<ITemplateBoundariesProcessor>> templateBoundariesProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<ICDATASectionProcessor>> cdataSectionProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<ICommentProcessor>> commentProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<IDocTypeProcessor>> docTypeProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<IProcessingInstructionProcessor>> processingInstructionProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<ITextProcessor>> textProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<IXMLDeclarationProcessor>> xmlDeclarationProcessorsByTemplateMode;
    private final EnumMap<TemplateMode, Set<IPreProcessor>> preProcessors;
    private final EnumMap<TemplateMode, Set<IPostProcessor>> postProcessors;

    public static DialectSetConfiguration build(Set<DialectConfiguration> dialectConfigurations) {
        Validate.notNull(dialectConfigurations, "Dialect configuration set cannot be null");
        LinkedHashSet<IDialect> dialects = new LinkedHashSet<IDialect>(dialectConfigurations.size());
        boolean standardDialectPresent = false;
        Iterator<IPreProcessor> standardDialectPrefix = null;
        LinkedHashMap<String, Object> executionAttributes = new LinkedHashMap<String, Object>(10, 1.0f);
        AggregateExpressionObjectFactory aggregateExpressionObjectFactory = new AggregateExpressionObjectFactory();
        EnumMap templateBoundariesProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap cdataSectionProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap commentProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap docTypeProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap elementProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap processingInstructionProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap textProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap xmlDeclarationProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap preProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        EnumMap postProcessorListsByTemplateMode = new EnumMap(TemplateMode.class);
        for (DialectConfiguration dialectConfiguration : dialectConfigurations) {
            Set<IPostProcessor> dialectPostProcessors;
            Class<? extends ITemplateHandler> handlerClass;
            TemplateMode templateMode;
            Set<IPreProcessor> dialectPreProcessors;
            IExpressionObjectFactory factory;
            Map<String, Object> dialectExecutionAttributes;
            Iterator<Object> dialectPrefix;
            IDialect dialect = dialectConfiguration.getDialect();
            if (dialect instanceof IProcessorDialect) {
                Set<IProcessor> dialectProcessors;
                IProcessorDialect processorDialect = (IProcessorDialect)dialect;
                Iterator<Object> iterator = dialectPrefix = dialectConfiguration.isPrefixSpecified() ? dialectConfiguration.getPrefix() : processorDialect.getPrefix();
                if (dialect instanceof StandardDialect) {
                    standardDialectPresent = true;
                    standardDialectPrefix = dialectPrefix;
                }
                if ((dialectProcessors = processorDialect.getProcessors((String)((Object)dialectPrefix))) == null) {
                    throw new ConfigurationException("Dialect should not return null processor set: " + dialect.getClass().getName());
                }
                for (IProcessor dialectProcessor : dialectProcessors) {
                    List processorsForTemplateMode;
                    if (dialectProcessor == null) {
                        throw new ConfigurationException("Dialect should not return null processor in processor set: " + dialect.getClass().getName());
                    }
                    TemplateMode templateMode2 = dialectProcessor.getTemplateMode();
                    if (templateMode2 == null) {
                        throw new ConfigurationException("Template mode cannot be null (processor: " + dialectProcessor.getClass().getName() + ")");
                    }
                    if (dialectProcessor instanceof IElementProcessor) {
                        processorsForTemplateMode = elementProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            elementProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((IElementProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (dialectProcessor instanceof ITemplateBoundariesProcessor) {
                        processorsForTemplateMode = templateBoundariesProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            templateBoundariesProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((ITemplateBoundariesProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (dialectProcessor instanceof ICDATASectionProcessor) {
                        processorsForTemplateMode = cdataSectionProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            cdataSectionProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((ICDATASectionProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (dialectProcessor instanceof ICommentProcessor) {
                        processorsForTemplateMode = commentProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            commentProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((ICommentProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (dialectProcessor instanceof IDocTypeProcessor) {
                        processorsForTemplateMode = docTypeProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            docTypeProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((IDocTypeProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (dialectProcessor instanceof IProcessingInstructionProcessor) {
                        processorsForTemplateMode = processingInstructionProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            processingInstructionProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((IProcessingInstructionProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (dialectProcessor instanceof ITextProcessor) {
                        processorsForTemplateMode = textProcessorListsByTemplateMode.get((Object)templateMode2);
                        if (processorsForTemplateMode == null) {
                            processorsForTemplateMode = new ArrayList(5);
                            textProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                        }
                        processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((ITextProcessor)dialectProcessor, processorDialect));
                        Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                        continue;
                    }
                    if (!(dialectProcessor instanceof IXMLDeclarationProcessor)) continue;
                    processorsForTemplateMode = xmlDeclarationProcessorListsByTemplateMode.get((Object)templateMode2);
                    if (processorsForTemplateMode == null) {
                        processorsForTemplateMode = new ArrayList(5);
                        xmlDeclarationProcessorListsByTemplateMode.put(templateMode2, processorsForTemplateMode);
                    }
                    processorsForTemplateMode.add(ProcessorConfigurationUtils.wrap((IXMLDeclarationProcessor)dialectProcessor, processorDialect));
                    Collections.sort(processorsForTemplateMode, ProcessorComparators.PROCESSOR_COMPARATOR);
                }
            }
            if (dialect instanceof IExecutionAttributeDialect && (dialectExecutionAttributes = ((IExecutionAttributeDialect)dialect).getExecutionAttributes()) != null) {
                dialectPrefix = dialectExecutionAttributes.entrySet().iterator();
                while (dialectPrefix.hasNext()) {
                    Map.Entry entry = (Map.Entry)dialectPrefix.next();
                    String executionAttributeName = (String)entry.getKey();
                    if (executionAttributes.containsKey(executionAttributeName)) {
                        throw new ConfigurationException("Conflicting execution attribute. Two or more dialects specify an execution attribute with the same name \"" + executionAttributeName + "\".");
                    }
                    executionAttributes.put((String)entry.getKey(), entry.getValue());
                }
            }
            if (dialect instanceof IExpressionObjectDialect && (factory = ((IExpressionObjectDialect)dialect).getExpressionObjectFactory()) != null) {
                aggregateExpressionObjectFactory.add(factory);
            }
            if (dialect instanceof IPreProcessorDialect && (dialectPreProcessors = ((IPreProcessorDialect)dialect).getPreProcessors()) != null) {
                dialectPrefix = dialectPreProcessors.iterator();
                while (dialectPrefix.hasNext()) {
                    IPreProcessor preProcessor = (IPreProcessor)dialectPrefix.next();
                    if (preProcessor == null) {
                        throw new ConfigurationException("Pre-Processor list for dialect " + dialect.getClass().getName() + " includes a null entry, which is forbidden.");
                    }
                    templateMode = preProcessor.getTemplateMode();
                    if (templateMode == null) {
                        throw new ConfigurationException("Template mode cannot be null (pre-processor: " + preProcessor.getClass().getName() + ", dialect" + dialect.getClass().getName() + ")");
                    }
                    handlerClass = preProcessor.getHandlerClass();
                    if (handlerClass == null) {
                        throw new ConfigurationException("Pre-Processor " + preProcessor.getClass().getName() + " for dialect " + preProcessor.getClass().getName() + " returns a null handler class, which is forbidden.");
                    }
                    if (!ITemplateHandler.class.isAssignableFrom(handlerClass)) {
                        throw new ConfigurationException("Handler class " + handlerClass.getName() + " specified for pre-processor " + preProcessor.getClass().getName() + " in dialect " + dialect.getClass().getName() + " does not implement required interface " + ITemplateHandler.class.getName());
                    }
                    try {
                        handlerClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ConfigurationException("Pre-Processor class " + handlerClass.getName() + " specified for pre-processor " + preProcessor.getClass().getName() + " in dialect " + dialect.getClass().getName() + " does not implement required zero-argument constructor.", e);
                    }
                    List preProcessorsForTemplateMode = preProcessorListsByTemplateMode.get((Object)templateMode);
                    if (preProcessorsForTemplateMode == null) {
                        preProcessorsForTemplateMode = new ArrayList(5);
                        preProcessorListsByTemplateMode.put(templateMode, preProcessorsForTemplateMode);
                    }
                    preProcessorsForTemplateMode.add(preProcessor);
                    Collections.sort(preProcessorsForTemplateMode, ProcessorComparators.PRE_PROCESSOR_COMPARATOR);
                }
            }
            if (dialect instanceof IPostProcessorDialect && (dialectPostProcessors = ((IPostProcessorDialect)dialect).getPostProcessors()) != null) {
                dialectPrefix = dialectPostProcessors.iterator();
                while (dialectPrefix.hasNext()) {
                    IPostProcessor postProcessor = (IPostProcessor)dialectPrefix.next();
                    if (postProcessor == null) {
                        throw new ConfigurationException("Post-Processor list for dialect " + dialect.getClass().getName() + " includes a null entry, which is forbidden.");
                    }
                    templateMode = postProcessor.getTemplateMode();
                    if (templateMode == null) {
                        throw new ConfigurationException("Template mode cannot be null (post-processor: " + postProcessor.getClass().getName() + ", dialect" + dialect.getClass().getName() + ")");
                    }
                    handlerClass = postProcessor.getHandlerClass();
                    if (handlerClass == null) {
                        throw new ConfigurationException("Post-Processor " + postProcessor.getClass().getName() + " for dialect " + postProcessor.getClass().getName() + " returns a null handler class, which is forbidden.");
                    }
                    if (!ITemplateHandler.class.isAssignableFrom(handlerClass)) {
                        throw new ConfigurationException("Handler class " + handlerClass.getName() + " specified for post-processor " + postProcessor.getClass().getName() + " in dialect " + dialect.getClass().getName() + " does not implement required interface " + ITemplateHandler.class.getName());
                    }
                    try {
                        handlerClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new ConfigurationException("Post-Processor class " + handlerClass.getName() + " specified for post-processor " + postProcessor.getClass().getName() + " in dialect " + dialect.getClass().getName() + " does not implement required zero-argument constructor.", e);
                    }
                    List postProcessorsForTemplateMode = postProcessorListsByTemplateMode.get((Object)templateMode);
                    if (postProcessorsForTemplateMode == null) {
                        postProcessorsForTemplateMode = new ArrayList(5);
                        postProcessorListsByTemplateMode.put(templateMode, postProcessorsForTemplateMode);
                    }
                    postProcessorsForTemplateMode.add(postProcessor);
                    Collections.sort(postProcessorsForTemplateMode, ProcessorComparators.POST_PROCESSOR_COMPARATOR);
                }
            }
            dialects.add(dialect);
        }
        EnumMap<TemplateMode, Set<ITemplateBoundariesProcessor>> templateBoundariesProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(templateBoundariesProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<ICDATASectionProcessor>> cdataSectionProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(cdataSectionProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<ICommentProcessor>> commentProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(commentProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<IDocTypeProcessor>> docTypeProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(docTypeProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(elementProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<IProcessingInstructionProcessor>> processingInstructionProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(processingInstructionProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<ITextProcessor>> textProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(textProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<IXMLDeclarationProcessor>> xmlDeclarationProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(xmlDeclarationProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<IPreProcessor>> preProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(preProcessorListsByTemplateMode);
        EnumMap<TemplateMode, Set<IPostProcessor>> postProcessorsByTemplateMode = DialectSetConfiguration.listMapToSetMap(postProcessorListsByTemplateMode);
        ElementDefinitions elementDefinitions = new ElementDefinitions(elementProcessorsByTemplateMode);
        AttributeDefinitions attributeDefinitions = new AttributeDefinitions(elementProcessorsByTemplateMode);
        DialectSetConfiguration.initializeDefinitionsForProcessors(templateBoundariesProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(cdataSectionProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(commentProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(docTypeProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(elementProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(processingInstructionProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(textProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForProcessors(xmlDeclarationProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForPreProcessors(preProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        DialectSetConfiguration.initializeDefinitionsForPostProcessors(postProcessorsByTemplateMode, elementDefinitions, attributeDefinitions);
        return new DialectSetConfiguration((Set<DialectConfiguration>)new LinkedHashSet<DialectConfiguration>(dialectConfigurations), (Set<IDialect>)dialects, standardDialectPresent, (String)((Object)standardDialectPrefix), (Map<String, Object>)executionAttributes, aggregateExpressionObjectFactory, elementDefinitions, attributeDefinitions, templateBoundariesProcessorsByTemplateMode, cdataSectionProcessorsByTemplateMode, commentProcessorsByTemplateMode, docTypeProcessorsByTemplateMode, elementProcessorsByTemplateMode, processingInstructionProcessorsByTemplateMode, textProcessorsByTemplateMode, xmlDeclarationProcessorsByTemplateMode, preProcessorsByTemplateMode, postProcessorsByTemplateMode);
    }

    private static <T> EnumMap<TemplateMode, Set<T>> listMapToSetMap(EnumMap<TemplateMode, List<T>> map) {
        EnumMap<TemplateMode, Set<T>> newMap = new EnumMap<TemplateMode, Set<T>>(TemplateMode.class);
        for (Map.Entry<TemplateMode, List<T>> entry : map.entrySet()) {
            newMap.put((TemplateMode)((Enum)entry.getKey()), new LinkedHashSet(entry.getValue()));
        }
        return newMap;
    }

    private static void initializeDefinitionsForProcessors(EnumMap<TemplateMode, ? extends Set<? extends IProcessor>> processorsByTemplateMode, ElementDefinitions elementDefinitions, AttributeDefinitions attributeDefinitions) {
        for (Map.Entry<TemplateMode, ? extends Set<? extends IProcessor>> entry : processorsByTemplateMode.entrySet()) {
            Set<? extends IProcessor> processors = entry.getValue();
            for (IProcessor iProcessor : processors) {
                if (iProcessor instanceof IElementDefinitionsAware) {
                    ((IElementDefinitionsAware)((Object)iProcessor)).setElementDefinitions(elementDefinitions);
                }
                if (!(iProcessor instanceof IAttributeDefinitionsAware)) continue;
                ((IAttributeDefinitionsAware)((Object)iProcessor)).setAttributeDefinitions(attributeDefinitions);
            }
        }
    }

    private static void initializeDefinitionsForPreProcessors(EnumMap<TemplateMode, ? extends Set<IPreProcessor>> preProcessorsByTemplateMode, ElementDefinitions elementDefinitions, AttributeDefinitions attributeDefinitions) {
        for (Map.Entry<TemplateMode, ? extends Set<IPreProcessor>> entry : preProcessorsByTemplateMode.entrySet()) {
            Set<IPreProcessor> preProcessors = entry.getValue();
            for (IPreProcessor preProcessor : preProcessors) {
                if (preProcessor instanceof IElementDefinitionsAware) {
                    ((IElementDefinitionsAware)((Object)preProcessor)).setElementDefinitions(elementDefinitions);
                }
                if (!(preProcessor instanceof IAttributeDefinitionsAware)) continue;
                ((IAttributeDefinitionsAware)((Object)preProcessor)).setAttributeDefinitions(attributeDefinitions);
            }
        }
    }

    private static void initializeDefinitionsForPostProcessors(EnumMap<TemplateMode, ? extends Set<IPostProcessor>> postProcessorsByTemplateMode, ElementDefinitions elementDefinitions, AttributeDefinitions attributeDefinitions) {
        for (Map.Entry<TemplateMode, ? extends Set<IPostProcessor>> entry : postProcessorsByTemplateMode.entrySet()) {
            Set<IPostProcessor> postProcessors = entry.getValue();
            for (IPostProcessor postProcessor : postProcessors) {
                if (postProcessor instanceof IElementDefinitionsAware) {
                    ((IElementDefinitionsAware)((Object)postProcessor)).setElementDefinitions(elementDefinitions);
                }
                if (!(postProcessor instanceof IAttributeDefinitionsAware)) continue;
                ((IAttributeDefinitionsAware)((Object)postProcessor)).setAttributeDefinitions(attributeDefinitions);
            }
        }
    }

    private DialectSetConfiguration(Set<DialectConfiguration> dialectConfigurations, Set<IDialect> dialects, boolean standardDialectPresent, String standardDialectPrefix, Map<String, Object> executionAttributes, AggregateExpressionObjectFactory expressionObjectFactory, ElementDefinitions elementDefinitions, AttributeDefinitions attributeDefinitions, EnumMap<TemplateMode, Set<ITemplateBoundariesProcessor>> templateBoundariesProcessorsByTemplateMode, EnumMap<TemplateMode, Set<ICDATASectionProcessor>> cdataSectionProcessorsByTemplateMode, EnumMap<TemplateMode, Set<ICommentProcessor>> commentProcessorsByTemplateMode, EnumMap<TemplateMode, Set<IDocTypeProcessor>> docTypeProcessorsByTemplateMode, EnumMap<TemplateMode, Set<IElementProcessor>> elementProcessorsByTemplateMode, EnumMap<TemplateMode, Set<IProcessingInstructionProcessor>> processingInstructionProcessorsByTemplateMode, EnumMap<TemplateMode, Set<ITextProcessor>> textProcessorsByTemplateMode, EnumMap<TemplateMode, Set<IXMLDeclarationProcessor>> xmlDeclarationProcessorsByTemplateMode, EnumMap<TemplateMode, Set<IPreProcessor>> preProcessors, EnumMap<TemplateMode, Set<IPostProcessor>> postProcessors) {
        this.dialectConfigurations = Collections.unmodifiableSet(dialectConfigurations);
        this.dialects = Collections.unmodifiableSet(dialects);
        this.standardDialectPresent = standardDialectPresent;
        this.standardDialectPrefix = standardDialectPrefix;
        this.executionAttributes = Collections.unmodifiableMap(executionAttributes);
        this.expressionObjectFactory = expressionObjectFactory;
        this.elementDefinitions = elementDefinitions;
        this.attributeDefinitions = attributeDefinitions;
        this.templateBoundariesProcessorsByTemplateMode = templateBoundariesProcessorsByTemplateMode;
        this.cdataSectionProcessorsByTemplateMode = cdataSectionProcessorsByTemplateMode;
        this.commentProcessorsByTemplateMode = commentProcessorsByTemplateMode;
        this.docTypeProcessorsByTemplateMode = docTypeProcessorsByTemplateMode;
        this.elementProcessorsByTemplateMode = elementProcessorsByTemplateMode;
        this.processingInstructionProcessorsByTemplateMode = processingInstructionProcessorsByTemplateMode;
        this.textProcessorsByTemplateMode = textProcessorsByTemplateMode;
        this.xmlDeclarationProcessorsByTemplateMode = xmlDeclarationProcessorsByTemplateMode;
        this.preProcessors = preProcessors;
        this.postProcessors = postProcessors;
    }

    public Set<DialectConfiguration> getDialectConfigurations() {
        return this.dialectConfigurations;
    }

    public Set<IDialect> getDialects() {
        return this.dialects;
    }

    public boolean isStandardDialectPresent() {
        return this.standardDialectPresent;
    }

    public String getStandardDialectPrefix() {
        return this.standardDialectPrefix;
    }

    public Map<String, Object> getExecutionAttributes() {
        return this.executionAttributes;
    }

    public Object getExecutionAttribute(String executionAttributeName) {
        return this.executionAttributes.get(executionAttributeName);
    }

    public boolean hasExecutionAttribute(String executionAttributeName) {
        return this.executionAttributes.containsKey(executionAttributeName);
    }

    public ElementDefinitions getElementDefinitions() {
        return this.elementDefinitions;
    }

    public AttributeDefinitions getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public Set<ITemplateBoundariesProcessor> getTemplateBoundariesProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<ITemplateBoundariesProcessor> processors = this.templateBoundariesProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<ICDATASectionProcessor> getCDATASectionProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<ICDATASectionProcessor> processors = this.cdataSectionProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<ICommentProcessor> getCommentProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<ICommentProcessor> processors = this.commentProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<IDocTypeProcessor> getDocTypeProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<IDocTypeProcessor> processors = this.docTypeProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<IElementProcessor> getElementProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<IElementProcessor> processors = this.elementProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<IProcessingInstructionProcessor> getProcessingInstructionProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<IProcessingInstructionProcessor> processors = this.processingInstructionProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<ITextProcessor> getTextProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<ITextProcessor> processors = this.textProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<IXMLDeclarationProcessor> getXMLDeclarationProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<IXMLDeclarationProcessor> processors = this.xmlDeclarationProcessorsByTemplateMode.get((Object)templateMode);
        if (processors == null) {
            return Collections.EMPTY_SET;
        }
        return processors;
    }

    public Set<IPreProcessor> getPreProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<IPreProcessor> preProcessors = this.preProcessors.get((Object)templateMode);
        if (preProcessors == null) {
            return Collections.EMPTY_SET;
        }
        return preProcessors;
    }

    public Set<IPostProcessor> getPostProcessors(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Set<IPostProcessor> postProcessors = this.postProcessors.get((Object)templateMode);
        if (postProcessors == null) {
            return Collections.EMPTY_SET;
        }
        return postProcessors;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return this.expressionObjectFactory;
    }

    static class AggregateExpressionObjectFactory
    implements IExpressionObjectFactory {
        private IExpressionObjectFactory firstExpressionObjectFactory = null;
        private List<IExpressionObjectFactory> expressionObjectFactoryList = null;

        AggregateExpressionObjectFactory() {
        }

        void add(IExpressionObjectFactory expressionObjectFactory) {
            if (this.firstExpressionObjectFactory == null && this.expressionObjectFactoryList == null) {
                this.firstExpressionObjectFactory = expressionObjectFactory;
                return;
            }
            if (this.expressionObjectFactoryList == null) {
                this.expressionObjectFactoryList = new ArrayList<IExpressionObjectFactory>(2);
                this.expressionObjectFactoryList.add(this.firstExpressionObjectFactory);
                this.firstExpressionObjectFactory = null;
            }
            this.expressionObjectFactoryList.add(expressionObjectFactory);
        }

        @Override
        public Set<String> getAllExpressionObjectNames() {
            if (this.firstExpressionObjectFactory != null) {
                return this.firstExpressionObjectFactory.getAllExpressionObjectNames();
            }
            if (this.expressionObjectFactoryList == null) {
                return null;
            }
            LinkedHashSet<String> expressionObjectNames = new LinkedHashSet<String>(30);
            int n = this.expressionObjectFactoryList.size();
            while (n-- != 0) {
                expressionObjectNames.addAll(this.expressionObjectFactoryList.get(n).getAllExpressionObjectNames());
            }
            return expressionObjectNames;
        }

        @Override
        public Object buildObject(IExpressionContext context, String expressionObjectName) {
            if (this.firstExpressionObjectFactory != null) {
                return this.firstExpressionObjectFactory.buildObject(context, expressionObjectName);
            }
            if (this.expressionObjectFactoryList == null) {
                return null;
            }
            int n = this.expressionObjectFactoryList.size();
            while (n-- != 0) {
                if (!this.expressionObjectFactoryList.get(n).getAllExpressionObjectNames().contains(expressionObjectName)) continue;
                return this.expressionObjectFactoryList.get(n).buildObject(context, expressionObjectName);
            }
            return null;
        }

        @Override
        public boolean isCacheable(String expressionObjectName) {
            if (this.firstExpressionObjectFactory != null) {
                return this.firstExpressionObjectFactory.isCacheable(expressionObjectName);
            }
            if (this.expressionObjectFactoryList == null) {
                return false;
            }
            int n = this.expressionObjectFactoryList.size();
            while (n-- != 0) {
                if (!this.expressionObjectFactoryList.get(n).getAllExpressionObjectNames().contains(expressionObjectName)) continue;
                return this.expressionObjectFactoryList.get(n).isCacheable(expressionObjectName);
            }
            return false;
        }
    }
}

