/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.HTMLAttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.TextAttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.XMLAttributeName;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.TextUtils;

public class AttributeNames {
    private static final AttributeNamesRepository htmlAttributeNamesRepository = new AttributeNamesRepository(TemplateMode.HTML);
    private static final AttributeNamesRepository xmlAttributeNamesRepository = new AttributeNamesRepository(TemplateMode.XML);
    private static final AttributeNamesRepository textAttributeNamesRepository = new AttributeNamesRepository(TemplateMode.TEXT);

    private static TextAttributeName buildTextAttributeName(char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (attributeNameBuffer == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Attribute name buffer cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Attribute name offset and len must be equal or greater than zero");
        }
        int i = attributeNameOffset;
        int n = attributeNameLen;
        while (n-- != 0) {
            char c;
            if ((c = attributeNameBuffer[i++]) != ':' || c != ':') continue;
            if (i == attributeNameOffset + 1) {
                return TextAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
            }
            return TextAttributeName.forName(new String(attributeNameBuffer, attributeNameOffset, i - (attributeNameOffset + 1)), new String(attributeNameBuffer, i, attributeNameOffset + attributeNameLen - i));
        }
        return TextAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
    }

    private static XMLAttributeName buildXMLAttributeName(char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (attributeNameBuffer == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Attribute name buffer cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Attribute name offset and len must be equal or greater than zero");
        }
        int i = attributeNameOffset;
        int n = attributeNameLen;
        while (n-- != 0) {
            char c;
            if ((c = attributeNameBuffer[i++]) != ':' || c != ':') continue;
            if (i == attributeNameOffset + 1) {
                return XMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
            }
            return XMLAttributeName.forName(new String(attributeNameBuffer, attributeNameOffset, i - (attributeNameOffset + 1)), new String(attributeNameBuffer, i, attributeNameOffset + attributeNameLen - i));
        }
        return XMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
    }

    private static HTMLAttributeName buildHTMLAttributeName(char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (attributeNameBuffer == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Attribute name buffer cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Attribute name offset and len must be equal or greater than zero");
        }
        int i = attributeNameOffset;
        int n = attributeNameLen;
        boolean inData = false;
        while (n-- != 0) {
            char c;
            if ((c = attributeNameBuffer[i++]) != ':' && c != '-') continue;
            if (!inData && c == ':') {
                if (i == attributeNameOffset + 1) {
                    return HTMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
                }
                if (TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xml:", 0, 4, attributeNameBuffer, attributeNameOffset, i - attributeNameOffset) || TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xmlns:", 0, 6, attributeNameBuffer, attributeNameOffset, i - attributeNameOffset)) {
                    return HTMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
                }
                return HTMLAttributeName.forName(new String(attributeNameBuffer, attributeNameOffset, i - (attributeNameOffset + 1)), new String(attributeNameBuffer, i, attributeNameOffset + attributeNameLen - i));
            }
            if (!inData && c == '-') {
                if (i == attributeNameOffset + 5 && TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"data", 0, 4, attributeNameBuffer, attributeNameOffset, i - (attributeNameOffset + 1))) {
                    inData = true;
                    continue;
                }
                return HTMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
            }
            if (!inData || c != '-') continue;
            if (i == attributeNameOffset + 6) {
                return HTMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
            }
            return HTMLAttributeName.forName(new String(attributeNameBuffer, attributeNameOffset + 5, i - (attributeNameOffset + 6)), new String(attributeNameBuffer, i, attributeNameOffset + attributeNameLen - i));
        }
        return HTMLAttributeName.forName(null, new String(attributeNameBuffer, attributeNameOffset, attributeNameLen));
    }

    private static TextAttributeName buildTextAttributeName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
        int i = 0;
        int n = attributeName.length();
        while (n-- != 0) {
            char c;
            if ((c = attributeName.charAt(i++)) != ':' || c != ':') continue;
            if (i == 1) {
                return TextAttributeName.forName(null, attributeName);
            }
            return TextAttributeName.forName(attributeName.substring(0, i - 1), attributeName.substring(i, attributeName.length()));
        }
        return TextAttributeName.forName(null, attributeName);
    }

    private static XMLAttributeName buildXMLAttributeName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
        int i = 0;
        int n = attributeName.length();
        while (n-- != 0) {
            char c;
            if ((c = attributeName.charAt(i++)) != ':' || c != ':') continue;
            if (i == 1) {
                return XMLAttributeName.forName(null, attributeName);
            }
            return XMLAttributeName.forName(attributeName.substring(0, i - 1), attributeName.substring(i, attributeName.length()));
        }
        return XMLAttributeName.forName(null, attributeName);
    }

    private static HTMLAttributeName buildHTMLAttributeName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
        int i = 0;
        int n = attributeName.length();
        boolean inData = false;
        while (n-- != 0) {
            char c;
            if ((c = attributeName.charAt(i++)) != ':' && c != '-') continue;
            if (!inData && c == ':') {
                if (i == 1) {
                    return HTMLAttributeName.forName(null, attributeName);
                }
                if (TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xml:", 0, 4, attributeName, 0, i) || TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"xmlns:", 0, 6, attributeName, 0, i)) {
                    return HTMLAttributeName.forName(null, attributeName);
                }
                return HTMLAttributeName.forName(attributeName.substring(0, i - 1), attributeName.substring(i, attributeName.length()));
            }
            if (!inData && c == '-') {
                if (i == 5 && TextUtils.equals(TemplateMode.HTML.isCaseSensitive(), (CharSequence)"data", 0, 4, attributeName, 0, 4)) {
                    inData = true;
                    continue;
                }
                return HTMLAttributeName.forName(null, attributeName);
            }
            if (!inData || c != '-') continue;
            if (i == 6) {
                return HTMLAttributeName.forName(null, attributeName);
            }
            return HTMLAttributeName.forName(attributeName.substring(5, i - 1), attributeName.substring(i, attributeName.length()));
        }
        return HTMLAttributeName.forName(null, attributeName);
    }

    private static TextAttributeName buildTextAttributeName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
        if (prefix == null || prefix.trim().length() == 0) {
            return AttributeNames.buildTextAttributeName(attributeName);
        }
        return TextAttributeName.forName(prefix, attributeName);
    }

    private static XMLAttributeName buildXMLAttributeName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
        if (prefix == null || prefix.trim().length() == 0) {
            return AttributeNames.buildXMLAttributeName(attributeName);
        }
        return XMLAttributeName.forName(prefix, attributeName);
    }

    private static HTMLAttributeName buildHTMLAttributeName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            throw new IllegalArgumentException("Attribute name cannot be null or empty");
        }
        if (prefix == null || prefix.trim().length() == 0) {
            return AttributeNames.buildHTMLAttributeName(attributeName);
        }
        return HTMLAttributeName.forName(prefix, attributeName);
    }

    public static AttributeName forName(TemplateMode templateMode, char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        if (templateMode == TemplateMode.HTML) {
            return AttributeNames.forHTMLName(attributeNameBuffer, attributeNameOffset, attributeNameLen);
        }
        if (templateMode == TemplateMode.XML) {
            return AttributeNames.forXMLName(attributeNameBuffer, attributeNameOffset, attributeNameLen);
        }
        if (templateMode.isText()) {
            return AttributeNames.forTextName(attributeNameBuffer, attributeNameOffset, attributeNameLen);
        }
        throw new IllegalArgumentException("Unknown template mode '" + (Object)((Object)templateMode) + "'");
    }

    public static AttributeName forName(TemplateMode templateMode, String attributeName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        if (templateMode == TemplateMode.HTML) {
            return AttributeNames.forHTMLName(attributeName);
        }
        if (templateMode == TemplateMode.XML) {
            return AttributeNames.forXMLName(attributeName);
        }
        if (templateMode.isText()) {
            return AttributeNames.forTextName(attributeName);
        }
        throw new IllegalArgumentException("Unknown template mode '" + (Object)((Object)templateMode) + "'");
    }

    public static AttributeName forName(TemplateMode templateMode, String prefix, String attributeName) {
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode cannot be null");
        }
        if (templateMode == TemplateMode.HTML) {
            return AttributeNames.forHTMLName(prefix, attributeName);
        }
        if (templateMode == TemplateMode.XML) {
            return AttributeNames.forXMLName(prefix, attributeName);
        }
        if (templateMode.isText()) {
            return AttributeNames.forTextName(prefix, attributeName);
        }
        throw new IllegalArgumentException("Unknown template mode '" + (Object)((Object)templateMode) + "'");
    }

    public static TextAttributeName forTextName(char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (attributeNameBuffer == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (TextAttributeName)textAttributeNamesRepository.getAttribute(attributeNameBuffer, attributeNameOffset, attributeNameLen);
    }

    public static XMLAttributeName forXMLName(char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (attributeNameBuffer == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (XMLAttributeName)xmlAttributeNamesRepository.getAttribute(attributeNameBuffer, attributeNameOffset, attributeNameLen);
    }

    public static HTMLAttributeName forHTMLName(char[] attributeNameBuffer, int attributeNameOffset, int attributeNameLen) {
        if (attributeNameBuffer == null || attributeNameLen == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (attributeNameOffset < 0 || attributeNameLen < 0) {
            throw new IllegalArgumentException("Both name offset and length must be equal to or greater than zero");
        }
        return (HTMLAttributeName)htmlAttributeNamesRepository.getAttribute(attributeNameBuffer, attributeNameOffset, attributeNameLen);
    }

    public static TextAttributeName forTextName(String attributeName) {
        if (attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeName)textAttributeNamesRepository.getAttribute(attributeName);
    }

    public static XMLAttributeName forXMLName(String attributeName) {
        if (attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLAttributeName)xmlAttributeNamesRepository.getAttribute(attributeName);
    }

    public static HTMLAttributeName forHTMLName(String attributeName) {
        if (attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLAttributeName)htmlAttributeNamesRepository.getAttribute(attributeName);
    }

    public static TextAttributeName forTextName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (TextAttributeName)textAttributeNamesRepository.getAttribute(prefix, attributeName);
    }

    public static XMLAttributeName forXMLName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (XMLAttributeName)xmlAttributeNamesRepository.getAttribute(prefix, attributeName);
    }

    public static HTMLAttributeName forHTMLName(String prefix, String attributeName) {
        if (attributeName == null || attributeName.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        return (HTMLAttributeName)htmlAttributeNamesRepository.getAttribute(prefix, attributeName);
    }

    private AttributeNames() {
    }

    static final class AttributeNamesRepository {
        private final TemplateMode templateMode;
        private final List<String> repositoryNames;
        private final List<AttributeName> repository;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
        private final Lock readLock = this.lock.readLock();
        private final Lock writeLock = this.lock.writeLock();

        AttributeNamesRepository(TemplateMode templateMode) {
            this.templateMode = templateMode;
            this.repositoryNames = new ArrayList<String>(500);
            this.repository = new ArrayList<AttributeName>(500);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributeName getAttribute(char[] text, int offset, int len) {
            this.readLock.lock();
            try {
                int index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
                if (index >= 0) {
                    AttributeName attributeName = this.repository.get(index);
                    return attributeName;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                AttributeName attributeName = this.storeAttribute(text, offset, len);
                return attributeName;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributeName getAttribute(String completeAttributeName) {
            this.readLock.lock();
            try {
                int index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                if (index >= 0) {
                    AttributeName attributeName = this.repository.get(index);
                    return attributeName;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                AttributeName attributeName = this.storeAttribute(completeAttributeName);
                return attributeName;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AttributeName getAttribute(String prefix, String attributeName) {
            this.readLock.lock();
            try {
                int index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, attributeName);
                if (index >= 0) {
                    AttributeName attributeName2 = this.repository.get(index);
                    return attributeName2;
                }
            }
            finally {
                this.readLock.unlock();
            }
            this.writeLock.lock();
            try {
                AttributeName attributeName3 = this.storeAttribute(prefix, attributeName);
                return attributeName3;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private AttributeName storeAttribute(char[] text, int offset, int len) {
            String[] completeAttributeNames;
            int index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, text, offset, len);
            if (index >= 0) {
                return this.repository.get(index);
            }
            AttributeName name = this.templateMode == TemplateMode.HTML ? AttributeNames.buildHTMLAttributeName(text, offset, len) : (this.templateMode == TemplateMode.XML ? AttributeNames.buildXMLAttributeName(text, offset, len) : AttributeNames.buildTextAttributeName(text, offset, len));
            for (String completeAttributeName : completeAttributeNames = name.completeAttributeNames) {
                index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, name);
            }
            return name;
        }

        private AttributeName storeAttribute(String attributeName) {
            String[] completeAttributeNames;
            int index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, attributeName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            AttributeName name = this.templateMode == TemplateMode.HTML ? AttributeNames.buildHTMLAttributeName(attributeName) : (this.templateMode == TemplateMode.XML ? AttributeNames.buildXMLAttributeName(attributeName) : AttributeNames.buildTextAttributeName(attributeName));
            for (String completeAttributeName : completeAttributeNames = name.completeAttributeNames) {
                index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, name);
            }
            return name;
        }

        private AttributeName storeAttribute(String prefix, String attributeName) {
            String[] completeAttributeNames;
            int index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, prefix, attributeName);
            if (index >= 0) {
                return this.repository.get(index);
            }
            AttributeName name = this.templateMode == TemplateMode.HTML ? AttributeNames.buildHTMLAttributeName(prefix, attributeName) : (this.templateMode == TemplateMode.XML ? AttributeNames.buildXMLAttributeName(prefix, attributeName) : AttributeNames.buildTextAttributeName(prefix, attributeName));
            for (String completeAttributeName : completeAttributeNames = name.completeAttributeNames) {
                index = AttributeNamesRepository.binarySearch(this.templateMode.isCaseSensitive(), this.repositoryNames, completeAttributeName);
                this.repositoryNames.add((index + 1) * -1, completeAttributeName);
                this.repository.add((index + 1) * -1, name);
            }
            return name;
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, char[] text, int offset, int len) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, 0, midVal.length(), text, offset, len);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String text) {
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, text);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        private static int binarySearch(boolean caseSensitive, List<String> values, String prefix, String attributeName) {
            if (prefix == null || prefix.trim().length() == 0) {
                return AttributeNamesRepository.binarySearch(caseSensitive, values, attributeName);
            }
            int prefixLen = prefix.length();
            int attributeNameLen = attributeName.length();
            int low = 0;
            int high = values.size() - 1;
            while (low <= high) {
                int cmp;
                int mid = low + high >>> 1;
                String midVal = values.get(mid);
                int midValLen = midVal.length();
                if (TextUtils.startsWith(caseSensitive, (CharSequence)midVal, prefix)) {
                    if (midValLen <= prefixLen) {
                        low = mid + 1;
                        continue;
                    }
                    cmp = midVal.charAt(prefixLen) - 58;
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefixLen + 1, midValLen - (prefixLen + 1), attributeName, 0, attributeNameLen);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                cmp = TextUtils.compareTo(caseSensitive, (CharSequence)midVal, prefix);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                throw new IllegalStateException("Bad comparison of midVal \"" + midVal + "\" and prefix \"" + prefix + "\"");
            }
            return -(low + 1);
        }
    }
}

