/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.List;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.engine.AbstractTemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.engine.CDATASection;
import org.ezlibs.shaded.org.thymeleaf.engine.CloseElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.Comment;
import org.ezlibs.shaded.org.thymeleaf.engine.DocType;
import org.ezlibs.shaded.org.thymeleaf.engine.IEngineTemplateEvent;
import org.ezlibs.shaded.org.thymeleaf.engine.OpenElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.ProcessingInstruction;
import org.ezlibs.shaded.org.thymeleaf.engine.StandaloneElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateData;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateEnd;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateModel;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateStart;
import org.ezlibs.shaded.org.thymeleaf.engine.Text;
import org.ezlibs.shaded.org.thymeleaf.engine.XMLDeclaration;
import org.ezlibs.shaded.org.thymeleaf.model.ICDATASection;
import org.ezlibs.shaded.org.thymeleaf.model.ICloseElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.IComment;
import org.ezlibs.shaded.org.thymeleaf.model.IDocType;
import org.ezlibs.shaded.org.thymeleaf.model.IOpenElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessingInstruction;
import org.ezlibs.shaded.org.thymeleaf.model.IStandaloneElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.ITemplateEnd;
import org.ezlibs.shaded.org.thymeleaf.model.ITemplateStart;
import org.ezlibs.shaded.org.thymeleaf.model.IText;
import org.ezlibs.shaded.org.thymeleaf.model.IXMLDeclaration;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class ModelBuilderTemplateHandler
extends AbstractTemplateHandler {
    private final List<IEngineTemplateEvent> events;
    private final IEngineConfiguration configuration;
    private final TemplateData templateData;

    public ModelBuilderTemplateHandler(IEngineConfiguration configuration, TemplateData templateData) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(templateData, "Template Data cannot be null");
        this.configuration = configuration;
        this.templateData = templateData;
        this.events = new ArrayList<IEngineTemplateEvent>(100);
    }

    public TemplateModel getModel() {
        return new TemplateModel(this.configuration, this.templateData, this.events.toArray(new IEngineTemplateEvent[this.events.size()]));
    }

    @Override
    public void handleTemplateStart(ITemplateStart templateStart) {
        this.events.add(TemplateStart.asEngineTemplateStart(templateStart));
        super.handleTemplateStart(templateStart);
    }

    @Override
    public void handleTemplateEnd(ITemplateEnd templateEnd) {
        this.events.add(TemplateEnd.asEngineTemplateEnd(templateEnd));
        super.handleTemplateEnd(templateEnd);
    }

    @Override
    public void handleText(IText text) {
        this.events.add(Text.asEngineText(text));
        super.handleText(text);
    }

    @Override
    public void handleComment(IComment comment) {
        this.events.add(Comment.asEngineComment(comment));
        super.handleComment(comment);
    }

    @Override
    public void handleCDATASection(ICDATASection cdataSection) {
        this.events.add(CDATASection.asEngineCDATASection(cdataSection));
        super.handleCDATASection(cdataSection);
    }

    @Override
    public void handleStandaloneElement(IStandaloneElementTag standaloneElementTag) {
        this.events.add(StandaloneElementTag.asEngineStandaloneElementTag(standaloneElementTag));
        super.handleStandaloneElement(standaloneElementTag);
    }

    @Override
    public void handleOpenElement(IOpenElementTag openElementTag) {
        this.events.add(OpenElementTag.asEngineOpenElementTag(openElementTag));
        super.handleOpenElement(openElementTag);
    }

    @Override
    public void handleCloseElement(ICloseElementTag closeElementTag) {
        this.events.add(CloseElementTag.asEngineCloseElementTag(closeElementTag));
        super.handleCloseElement(closeElementTag);
    }

    @Override
    public void handleDocType(IDocType docType) {
        this.events.add(DocType.asEngineDocType(docType));
        super.handleDocType(docType);
    }

    @Override
    public void handleXMLDeclaration(IXMLDeclaration xmlDeclaration) {
        this.events.add(XMLDeclaration.asEngineXMLDeclaration(xmlDeclaration));
        super.handleXMLDeclaration(xmlDeclaration);
    }

    @Override
    public void handleProcessingInstruction(IProcessingInstruction processingInstruction) {
        this.events.add(ProcessingInstruction.asEngineProcessingInstruction(processingInstruction));
        super.handleProcessingInstruction(processingInstruction);
    }
}

