/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.ezlibs.shaded.org.thymeleaf.engine.AbstractProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.Attribute;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.Attributes;
import org.ezlibs.shaded.org.thymeleaf.engine.ElementDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.IEngineTemplateEvent;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.model.AttributeValueQuotes;
import org.ezlibs.shaded.org.thymeleaf.model.IAttribute;
import org.ezlibs.shaded.org.thymeleaf.model.IModelVisitor;
import org.ezlibs.shaded.org.thymeleaf.model.IStandaloneElementTag;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

final class StandaloneElementTag
extends AbstractProcessableElementTag
implements IStandaloneElementTag,
IEngineTemplateEvent {
    final boolean minimized;

    StandaloneElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes, boolean synthetic, boolean minimized) {
        super(templateMode, elementDefinition, elementCompleteName, attributes, synthetic);
        Validate.isTrue(minimized || templateMode == TemplateMode.HTML, "Not-minimized standalone elements are only allowed in HTML template mode (is " + (Object)((Object)templateMode) + ")");
        this.minimized = minimized;
    }

    StandaloneElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes, boolean synthetic, boolean minimized, String templateName, int line, int col) {
        super(templateMode, elementDefinition, elementCompleteName, attributes, synthetic, templateName, line, col);
        Validate.isTrue(minimized || templateMode == TemplateMode.HTML, "Not-minimized standalone elements are only allowed in HTML template mode (is " + (Object)((Object)templateMode) + ")");
        this.minimized = minimized;
    }

    @Override
    public boolean isMinimized() {
        return this.minimized;
    }

    @Override
    StandaloneElementTag setAttribute(AttributeDefinitions attributeDefinitions, AttributeDefinition attributeDefinition, String completeName, String value, AttributeValueQuotes valueQuotes) {
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        Attributes newAttributes = oldAttributes.setAttribute(attributeDefinitions, this.templateMode, attributeDefinition, completeName, value, valueQuotes);
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag replaceAttribute(AttributeDefinitions attributeDefinitions, AttributeName oldName, AttributeDefinition newAttributeDefinition, String completeNewName, String value, AttributeValueQuotes valueQuotes) {
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        Attributes newAttributes = oldAttributes.replaceAttribute(attributeDefinitions, this.templateMode, oldName, newAttributeDefinition, completeNewName, value, valueQuotes);
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag removeAttribute(String prefix, String name) {
        Attributes newAttributes;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes = oldAttributes.removeAttribute(this.templateMode, prefix, name))) {
            return this;
        }
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag removeAttribute(String completeName) {
        Attributes newAttributes;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes = oldAttributes.removeAttribute(this.templateMode, completeName))) {
            return this;
        }
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    StandaloneElementTag removeAttribute(AttributeName attributeName) {
        Attributes newAttributes;
        Attributes oldAttributes = this.attributes != null ? this.attributes : Attributes.EMPTY_ATTRIBUTES;
        if (oldAttributes == (newAttributes = oldAttributes.removeAttribute(attributeName))) {
            return this;
        }
        return new StandaloneElementTag(this.templateMode, this.elementDefinition, this.elementCompleteName, newAttributes, this.synthetic, this.minimized, this.templateName, this.line, this.col);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.synthetic) {
            return;
        }
        if (this.templateMode.isText()) {
            writer.write("[#");
            writer.write(this.elementCompleteName);
            if (this.attributes != null) {
                this.attributes.write(writer);
            }
            if (this.minimized) {
                writer.write("/]");
            } else {
                writer.write("]");
            }
            return;
        }
        writer.write(60);
        writer.write(this.elementCompleteName);
        if (this.attributes != null) {
            this.attributes.write(writer);
        }
        if (this.minimized) {
            writer.write("/>");
        } else {
            writer.write(62);
        }
    }

    static StandaloneElementTag asEngineStandaloneElementTag(IStandaloneElementTag standaloneElementTag) {
        Attributes attributes;
        if (standaloneElementTag instanceof StandaloneElementTag) {
            return (StandaloneElementTag)standaloneElementTag;
        }
        IAttribute[] originalAttributeArray = standaloneElementTag.getAllAttributes();
        if (originalAttributeArray == null || originalAttributeArray.length == 0) {
            attributes = null;
        } else {
            Object[] newInnerWhiteSpaces;
            Attribute[] newAttributeArray = new Attribute[originalAttributeArray.length];
            for (int i = 0; i < originalAttributeArray.length; ++i) {
                IAttribute originalAttribute = originalAttributeArray[i];
                newAttributeArray[i] = new Attribute(originalAttribute.getAttributeDefinition(), originalAttribute.getAttributeCompleteName(), originalAttribute.getOperator(), originalAttribute.getValue(), originalAttribute.getValueQuotes(), originalAttribute.getTemplateName(), originalAttribute.getLine(), originalAttribute.getCol());
            }
            if (newAttributeArray.length == 1) {
                newInnerWhiteSpaces = Attributes.DEFAULT_WHITE_SPACE_ARRAY;
            } else {
                newInnerWhiteSpaces = new String[newAttributeArray.length];
                Arrays.fill(newInnerWhiteSpaces, " ");
            }
            attributes = new Attributes(newAttributeArray, (String[])newInnerWhiteSpaces);
        }
        return new StandaloneElementTag(standaloneElementTag.getTemplateMode(), standaloneElementTag.getElementDefinition(), standaloneElementTag.getElementCompleteName(), attributes, standaloneElementTag.isSynthetic(), standaloneElementTag.isMinimized(), standaloneElementTag.getTemplateName(), standaloneElementTag.getLine(), standaloneElementTag.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleStandaloneElement(this);
    }
}

