/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.ezlibs.shaded.org.thymeleaf.engine.AbstractTextualTemplateEvent;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.model.IModelVisitor;
import org.ezlibs.shaded.org.thymeleaf.model.IText;

final class Text
extends AbstractTextualTemplateEvent
implements IText {
    Text(CharSequence text) {
        super(text);
    }

    Text(CharSequence text, String templateName, int line, int col) {
        super(text, templateName, line, col);
    }

    @Override
    public String getText() {
        return this.getContentText();
    }

    @Override
    public int length() {
        return this.getContentLength();
    }

    @Override
    public char charAt(int index) {
        return this.charAtContent(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.contentSubSequence(start, end);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.writeContent(writer);
    }

    static Text asEngineText(IText text) {
        if (text instanceof Text) {
            return (Text)text;
        }
        return new Text(text.getText(), text.getTemplateName(), text.getLine(), text.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleText(this);
    }

    @Override
    public String toString() {
        return this.getText();
    }
}

