/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.processor.text;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.IText;
import org.ezlibs.shaded.org.thymeleaf.processor.AbstractProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.text.ITextProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.text.ITextStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractTextProcessor
extends AbstractProcessor
implements ITextProcessor {
    public AbstractTextProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IText text, ITextStructureHandler structureHandler) {
        try {
            this.doProcess(context, text, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (text.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(text.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(text.getLine(), text.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", text.getTemplateName(), text.getLine(), text.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IText var2, ITextStructureHandler var3);
}

