/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.util.ArrayList;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

final class ExpressionParsingState
extends ArrayList<ExpressionParsingNode> {
    private static final long serialVersionUID = 3972191269638891028L;

    ExpressionParsingState() {
    }

    public void addNode(String semiParsedString) {
        Validate.notNull(semiParsedString, "String cannot be null");
        this.add(new ExpressionParsingNode(semiParsedString));
    }

    public void addNode(Expression parsedExpression) {
        Validate.notNull(parsedExpression, "Expression cannot be null");
        this.add(new ExpressionParsingNode(parsedExpression));
    }

    public void insertNode(int pos, String semiParsedString) {
        Validate.notNull(semiParsedString, "String cannot be null");
        this.add(pos, new ExpressionParsingNode(semiParsedString));
    }

    public void insertNode(int pos, Expression parsedExpression) {
        Validate.notNull(parsedExpression, "Expression cannot be null");
        this.add(pos, new ExpressionParsingNode(parsedExpression));
    }

    public void setNode(int pos, String semiParsedString) {
        Validate.notNull(semiParsedString, "String cannot be null");
        this.set(pos, new ExpressionParsingNode(semiParsedString));
    }

    public void setNode(int pos, Expression parsedExpression) {
        Validate.notNull(parsedExpression, "Expression cannot be null");
        this.set(pos, new ExpressionParsingNode(parsedExpression));
    }

    public boolean hasStringRoot() {
        return this.hasStringAt(0);
    }

    public boolean hasExpressionRoot() {
        return this.hasExpressionAt(0);
    }

    public boolean hasStringAt(int pos) {
        return this.size() > pos && ((ExpressionParsingNode)this.get(pos)).isInput();
    }

    public boolean hasExpressionAt(int pos) {
        return this.size() > pos && ((ExpressionParsingNode)this.get(pos)).isExpression();
    }
}

