/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.BinaryOperationExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.DivisionExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingState;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.MultiplicationExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NumberTokenExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.RemainderExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.TextLiteralExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Token;

public abstract class MultiplicationDivisionRemainderExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -1364531602981256885L;
    protected static final String MULTIPLICATION_OPERATOR = "*";
    protected static final String DIVISION_OPERATOR = "/";
    protected static final String DIVISION_OPERATOR_2 = "div";
    protected static final String REMAINDER_OPERATOR = "%";
    protected static final String REMAINDER_OPERATOR_2 = "mod";
    static final String[] OPERATORS = new String[]{"*", "/", "div", "%", "mod"};
    private static final boolean[] LENIENCIES = new boolean[]{false, false, false, false, false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{MultiplicationExpression.class, DivisionExpression.class, DivisionExpression.class, RemainderExpression.class, RemainderExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    protected MultiplicationDivisionRemainderExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return right != null && (!(right instanceof Token) || right instanceof NumberTokenExpression) && !(right instanceof TextLiteralExpression);
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return left != null && (!(left instanceof Token) || left instanceof NumberTokenExpression) && !(left instanceof TextLiteralExpression);
    }

    static ExpressionParsingState composeMultiplicationDivisionRemainderExpression(ExpressionParsingState state, int nodeIndex) {
        return MultiplicationDivisionRemainderExpression.composeBinaryOperationExpression(state, nodeIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = MultiplicationDivisionRemainderExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = MultiplicationDivisionRemainderExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

