/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.expression;

import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.IExpressionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ComplexExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Expression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingState;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.util.EvaluationUtils;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class NegationExpression
extends ComplexExpression {
    private static final long serialVersionUID = -7131967162611145337L;
    private static final Logger logger = LoggerFactory.getLogger(NegationExpression.class);
    private static final String OPERATOR_1 = "!";
    private static final String OPERATOR_2 = "not";
    static final String[] OPERATORS = new String[]{"!", "not"};
    private final Expression operand;

    public NegationExpression(Expression operand) {
        Validate.notNull(operand, "Operand cannot be null");
        this.operand = operand;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append(OPERATOR_1);
        if (this.operand instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.operand);
            sb.append(')');
        } else {
            sb.append(this.operand);
        }
        return sb.toString();
    }

    public static ExpressionParsingState composeNegationExpression(ExpressionParsingState state, int nodeIndex) {
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        String trimmedInput = input.trim();
        String operatorFound = null;
        int operatorPos = trimmedInput.lastIndexOf(OPERATOR_1);
        if (operatorPos == -1) {
            operatorPos = trimmedInput.lastIndexOf(OPERATOR_2);
            if (operatorPos == -1) {
                return state;
            }
            operatorFound = OPERATOR_2;
        } else {
            operatorFound = OPERATOR_1;
        }
        if (operatorPos != 0) {
            return state;
        }
        String operandStr = trimmedInput.substring(operatorFound.length());
        Expression operandExpr = ExpressionParsingUtil.parseAndCompose(state, operandStr);
        if (operandExpr == null) {
            return null;
        }
        NegationExpression minusExpression = new NegationExpression(operandExpr);
        state.setNode(nodeIndex, minusExpression);
        return state;
    }

    static Object executeNegation(IExpressionContext context, NegationExpression expression, StandardExpressionExecutionContext expContext) {
        Object operandValue;
        boolean operandBooleanValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating negation expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return !(operandBooleanValue = EvaluationUtils.evaluateAsBoolean(operandValue = expression.getOperand().execute(context, expContext)));
    }
}

