/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import java.util.Map;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.context.IEngineContext;
import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateData;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateModel;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateInputException;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.ICloseElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.IModel;
import org.ezlibs.shaded.org.thymeleaf.model.IOpenElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.ITemplateEvent;
import org.ezlibs.shaded.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.Fragment;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentSignature;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentSignatureUtils;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NoOpToken;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressions;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.EscapedAttributeUtils;
import org.ezlibs.shaded.org.thymeleaf.util.FastStringWriter;
import org.ezlibs.shaded.org.thymeleaf.util.StringUtils;

public abstract class AbstractStandardFragmentInsertionTagProcessor
extends AbstractAttributeTagProcessor {
    private static final String FRAGMENT_ATTR_NAME = "fragment";
    private final boolean replaceHost;
    private final boolean insertOnlyContents;

    protected AbstractStandardFragmentInsertionTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, boolean replaceHost) {
        this(templateMode, dialectPrefix, attrName, precedence, replaceHost, false);
    }

    AbstractStandardFragmentInsertionTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, boolean replaceHost, boolean insertOnlyContents) {
        super(templateMode, dialectPrefix, null, false, attrName, true, precedence, true);
        this.replaceHost = replaceHost;
        this.insertOnlyContents = insertOnlyContents;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        FragmentSignature fragmentSignature;
        String string;
        String dialectPrefix;
        Object fragmentHolderEvent;
        ITemplateEvent firstEvent;
        if (StringUtils.isEmptyOrWhitespace(attributeValue)) {
            throw new TemplateProcessingException("Fragment specifications cannot be empty");
        }
        IEngineConfiguration configuration = context.getConfiguration();
        Object fragmentObj = AbstractStandardFragmentInsertionTagProcessor.computeFragment(context, attributeValue);
        if (fragmentObj == null) {
            throw new TemplateInputException("Error resolving fragment: \"" + attributeValue + "\": template or fragment could not be resolved");
        }
        if (fragmentObj == NoOpToken.VALUE) {
            return;
        }
        if (fragmentObj == Fragment.EMPTY_FRAGMENT) {
            if (this.replaceHost) {
                structureHandler.removeElement();
            } else {
                structureHandler.removeBody();
            }
            return;
        }
        Fragment fragment = (Fragment)fragmentObj;
        TemplateModel fragmentModel = fragment.getTemplateModel();
        Map<String, Object> fragmentParameters = fragment.getParameters();
        boolean signatureApplied = false;
        ITemplateEvent iTemplateEvent = firstEvent = fragmentModel.size() > 2 ? fragmentModel.get(1) : null;
        if (firstEvent != null && IProcessableElementTag.class.isAssignableFrom(firstEvent.getClass()) && (fragmentHolderEvent = (IProcessableElementTag)firstEvent).hasAttribute(dialectPrefix = attributeName.getPrefix(), FRAGMENT_ATTR_NAME) && !StringUtils.isEmptyOrWhitespace(string = EscapedAttributeUtils.unescapeAttribute(fragmentModel.getTemplateMode(), fragmentHolderEvent.getAttributeValue(dialectPrefix, FRAGMENT_ATTR_NAME))) && (fragmentSignature = FragmentSignatureUtils.parseFragmentSignature(configuration, string)) != null) {
            fragmentParameters = FragmentSignatureUtils.processParameters(fragmentSignature, fragmentParameters, fragment.hasSyntheticParameters());
            signatureApplied = true;
        }
        if (!signatureApplied && fragment.hasSyntheticParameters()) {
            throw new TemplateProcessingException("Fragment '" + attributeValue + "' specifies synthetic (unnamed) parameters, but the resolved fragment does not match a fragment signature (th:fragment,data-th-fragment) which could apply names to the specified parameters.");
        }
        if (context.getTemplateMode() != fragmentModel.getTemplateMode()) {
            if (this.insertOnlyContents) {
                throw new TemplateProcessingException("Template being processed uses template mode " + (Object)((Object)context.getTemplateMode()) + ", inserted fragment \"" + attributeValue + "\" uses template mode " + (Object)((Object)fragmentModel.getTemplateMode()) + ". Cross-template-mode fragment insertion is not allowed using the " + attributeName + " attribute, which is no longer recommended for use as of Thymeleaf 3.0. Use {th:insert,data-th-insert} or {th:replace,data-th-replace} instead, which do not remove the container element from the fragment being inserted.");
            }
            if (fragmentParameters != null && fragmentParameters.size() > 0) {
                if (!(context instanceof IEngineContext)) {
                    throw new TemplateProcessingException("Parameterized fragment insertion is not supported because local variable support is DISABLED. This is due to the use of an implementation of the " + ITemplateContext.class.getName() + " interface that does not provide local-variable support. In order to have local-variable support, the variables map implementation should also implement the " + IEngineContext.class.getName() + " interface");
                }
                ((IEngineContext)context).setVariables(fragmentParameters);
            }
            FastStringWriter stringWriter = new FastStringWriter(200);
            configuration.getTemplateManager().process(fragmentModel, context, stringWriter);
            if (this.replaceHost) {
                structureHandler.replaceWith(((Object)stringWriter).toString(), false);
            } else {
                structureHandler.setBody(((Object)stringWriter).toString(), false);
            }
            return;
        }
        TemplateData fragmentTemplateData = fragmentModel.getTemplateData();
        structureHandler.setTemplateData(fragmentTemplateData);
        if (fragmentParameters != null && fragmentParameters.size() > 0) {
            for (Map.Entry entry : fragmentParameters.entrySet()) {
                structureHandler.setLocalVariable((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.insertOnlyContents && fragmentTemplateData.hasTemplateSelectors()) {
            IModel model = fragmentModel.cloneModel();
            boolean bl = false;
            int n = model.size();
            while (n-- != 0) {
                void var15_19;
                ITemplateEvent event = model.get(n);
                if (event instanceof ICloseElementTag) {
                    if (((ICloseElementTag)event).isUnmatched()) continue;
                    if (var15_19 <= 0) {
                        model.remove(n);
                    }
                    ++var15_19;
                    continue;
                }
                if (event instanceof IOpenElementTag) {
                    if (--var15_19 > 0) continue;
                    model.remove(n);
                    continue;
                }
                if (var15_19 > 0) continue;
                model.remove(n);
            }
            if (this.replaceHost) {
                structureHandler.replaceWith(model, true);
            } else {
                structureHandler.setBody(model, true);
            }
            return;
        }
        if (this.replaceHost) {
            structureHandler.replaceWith(fragmentModel, true);
        } else {
            structureHandler.setBody(fragmentModel, true);
        }
    }

    private static Object computeFragment(ITemplateContext context, String input) {
        Object fragmentExpressionResult;
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
        String trimmedInput = input.trim();
        if (AbstractStandardFragmentInsertionTagProcessor.shouldBeWrappedAsFragmentExpression(trimmedInput)) {
            Object templateNameExpressionResult;
            FragmentExpression fragmentExpression = (FragmentExpression)expressionParser.parseExpression(context, "~{" + trimmedInput + "}");
            FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression(context, fragmentExpression);
            if (executedFragmentExpression.getFragmentSelectorExpressionResult() == null && executedFragmentExpression.getFragmentParameters() == null && (templateNameExpressionResult = executedFragmentExpression.getTemplateNameExpressionResult()) != null) {
                if (templateNameExpressionResult instanceof Fragment) {
                    return templateNameExpressionResult;
                }
                if (templateNameExpressionResult == NoOpToken.VALUE) {
                    return NoOpToken.VALUE;
                }
            }
            return FragmentExpression.resolveExecutedFragmentExpression(context, executedFragmentExpression, true);
        }
        IStandardExpression fragmentExpression = expressionParser.parseExpression(context, trimmedInput);
        if (fragmentExpression != null && fragmentExpression instanceof FragmentExpression) {
            FragmentExpression.ExecutedFragmentExpression executedFragmentExpression = FragmentExpression.createExecutedFragmentExpression(context, (FragmentExpression)fragmentExpression);
            fragmentExpressionResult = FragmentExpression.resolveExecutedFragmentExpression(context, executedFragmentExpression, true);
        } else {
            fragmentExpressionResult = fragmentExpression.execute(context);
        }
        if (fragmentExpressionResult == null || fragmentExpressionResult == NoOpToken.VALUE) {
            return fragmentExpressionResult;
        }
        if (!(fragmentExpressionResult instanceof Fragment)) {
            throw new TemplateProcessingException("Invalid fragment specification: \"" + input + "\": expression does not return a Fragment object");
        }
        return fragmentExpressionResult;
    }

    static boolean shouldBeWrappedAsFragmentExpression(String input) {
        int inputLen = input.length();
        if (inputLen > 2 && input.charAt(0) == '~' && input.charAt(1) == '{') {
            return false;
        }
        int bracketLevel = 0;
        int paramLevel = 0;
        boolean inLiteral = false;
        int n = inputLen;
        int i = 0;
        while (n-- != 0) {
            char c = input.charAt(i);
            if (c >= 'a' && c <= 'z' || c == ' ') {
                ++i;
                continue;
            }
            if (c == '\'') {
                inLiteral = !inLiteral;
            } else if (!inLiteral) {
                if (c == '{') {
                    ++bracketLevel;
                } else if (c == '}') {
                    --bracketLevel;
                } else if (bracketLevel == 0) {
                    if (c == '(') {
                        ++paramLevel;
                    } else if (c == ')') {
                        --paramLevel;
                    } else {
                        if (c == '=' && paramLevel == 1) {
                            return true;
                        }
                        if (c == '~' && n != 0 && input.charAt(i + 1) == '{') {
                            return false;
                        }
                        if (c == ':' && n != 0 && input.charAt(i + 1) == ':') {
                            return true;
                        }
                    }
                }
            }
            ++i;
        }
        return true;
    }
}

