/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.standard.util.StandardProcessorUtils;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.EvaluationUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class StandardConditionalFixedValueTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int PRECEDENCE = 1000;
    public static final String[] ATTR_NAMES = new String[]{"async", "autofocus", "autoplay", "checked", "controls", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "ismap", "loop", "multiple", "novalidate", "nowrap", "open", "pubdate", "readonly", "required", "reversed", "selected", "scoped", "seamless"};
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private final String targetAttributeCompleteName;
    private AttributeDefinition targetAttributeDefinition;

    public StandardConditionalFixedValueTagProcessor(String dialectPrefix, String attrName) {
        super(TEMPLATE_MODE, dialectPrefix, attrName, 1000, true, false);
        this.targetAttributeCompleteName = attrName;
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, this.targetAttributeCompleteName);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        if (EvaluationUtils.evaluateAsBoolean(expressionResult)) {
            StandardProcessorUtils.setAttribute(structureHandler, this.targetAttributeDefinition, this.targetAttributeCompleteName, this.targetAttributeCompleteName);
        } else {
            structureHandler.removeAttribute(this.targetAttributeDefinition.getAttributeName());
        }
    }
}

