/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.processor;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.EngineEventUtils;
import org.ezlibs.shaded.org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateManager;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateModel;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.IAttribute;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.NoOpToken;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.ezlibs.shaded.org.thymeleaf.standard.util.StandardProcessorUtils;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.EscapedAttributeUtils;
import org.ezlibs.shaded.org.thymeleaf.util.FastStringWriter;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class StandardDOMEventAttributeTagProcessor
extends AbstractAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int PRECEDENCE = 1000;
    public static final String[] ATTR_NAMES = new String[]{"onabort", "onafterprint", "onbeforeprint", "onbeforeunload", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "ondblclick", "ondrag", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "onformchange", "onforminput", "onhashchange", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmessage", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onoffline", "ononline", "onpause", "onplay", "onplaying", "onpopstate", "onprogress", "onratechange", "onreadystatechange", "onredo", "onreset", "onresize", "onscroll", "onseeked", "onseeking", "onselect", "onshow", "onstalled", "onstorage", "onsubmit", "onsuspend", "ontimeupdate", "onundo", "onunload", "onvolumechange", "onwaiting"};
    private final String targetAttrCompleteName;
    private AttributeDefinition targetAttributeDefinition;

    public StandardDOMEventAttributeTagProcessor(String dialectPrefix, String attrName) {
        super(TemplateMode.HTML, dialectPrefix, null, false, attrName, true, 1000, false);
        Validate.notNull(attrName, "Complete name of target attribute cannot be null");
        this.targetAttrCompleteName = attrName;
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(this.getTemplateMode(), this.targetAttrCompleteName);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = EscapedAttributeUtils.escapeAttribute(this.getTemplateMode(), expressionResult == null ? null : expressionResult.toString());
        if (newAttributeValue == null || newAttributeValue.length() == 0) {
            structureHandler.removeAttribute(this.targetAttributeDefinition.getAttributeName());
            structureHandler.removeAttribute(attributeName);
        } else {
            StandardProcessorUtils.replaceAttribute(structureHandler, attributeName, this.targetAttributeDefinition, this.targetAttrCompleteName, newAttributeValue == null ? "" : newAttributeValue);
        }
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        Object expressionResult;
        if (attributeValue != null) {
            IStandardExpression expression = null;
            try {
                expression = EngineEventUtils.computeAttributeExpression(context, tag, attributeName, attributeValue);
            }
            catch (TemplateProcessingException templateProcessingException) {
                // empty catch block
            }
            if (expression != null) {
                expressionResult = expression.execute(context, StandardExpressionExecutionContext.RESTRICTED_FORBID_UNSAFE_EXP_RESULTS);
            } else {
                IAttribute attribute = tag.getAttribute(attributeName);
                TemplateManager templateManager = context.getConfiguration().getTemplateManager();
                TemplateModel templateModel = templateManager.parseString(context.getTemplateData(), attributeValue, attribute.getLine(), attribute.getCol(), TemplateMode.JAVASCRIPT, true);
                FastStringWriter stringWriter = new FastStringWriter(50);
                templateManager.process(templateModel, context, stringWriter);
                expressionResult = ((Object)stringWriter).toString();
            }
        } else {
            expressionResult = null;
        }
        if (expressionResult == NoOpToken.VALUE) {
            structureHandler.removeAttribute(attributeName);
            return;
        }
        this.doProcess(context, tag, attributeName, attributeValue, expressionResult, structureHandler);
    }
}

