/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.standard.serializer;

import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.standard.serializer.IStandardCSSSerializer;
import org.ezlibs.shaded.org.thymeleaf.standard.serializer.IStandardJavaScriptSerializer;

public final class StandardSerializers {
    public static final String STANDARD_JAVASCRIPT_SERIALIZER_ATTRIBUTE_NAME = "StandardJavaScriptSerializer";
    public static final String STANDARD_CSS_SERIALIZER_ATTRIBUTE_NAME = "StandardCSSSerializer";

    private StandardSerializers() {
    }

    public static IStandardJavaScriptSerializer getJavaScriptSerializer(IEngineConfiguration configuration) {
        Object serializer = configuration.getExecutionAttributes().get(STANDARD_JAVASCRIPT_SERIALIZER_ATTRIBUTE_NAME);
        if (serializer == null || !(serializer instanceof IStandardJavaScriptSerializer)) {
            throw new TemplateProcessingException("No JavaScript Serializer has been registered as an execution argument. This is a requirement for using Standard serialization, and might happen if neither the Standard or the SpringStandard dialects have been added to the Template Engine and none of the specified dialects registers an attribute of type " + IStandardJavaScriptSerializer.class.getName() + " with name \"" + STANDARD_JAVASCRIPT_SERIALIZER_ATTRIBUTE_NAME + "\"");
        }
        return (IStandardJavaScriptSerializer)serializer;
    }

    public static IStandardCSSSerializer getCSSSerializer(IEngineConfiguration configuration) {
        Object serializer = configuration.getExecutionAttributes().get(STANDARD_CSS_SERIALIZER_ATTRIBUTE_NAME);
        if (serializer == null || !(serializer instanceof IStandardCSSSerializer)) {
            throw new TemplateProcessingException("No CSS Serializer has been registered as an execution argument. This is a requirement for using Standard serialization, and might happen if neither the Standard or the SpringStandard dialects have been added to the Template Engine and none of the specified dialects registers an attribute of type " + IStandardCSSSerializer.class.getName() + " with name \"" + STANDARD_CSS_SERIALIZER_ATTRIBUTE_NAME + "\"");
        }
        return (IStandardCSSSerializer)serializer;
    }
}

