/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.templatemode;

import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;

public enum TemplateMode {
    HTML(true, false, false),
    XML(false, true, false),
    TEXT(false, false, true),
    JAVASCRIPT(false, false, true),
    CSS(false, false, true),
    RAW(false, false, false),
    HTML5(true, false, false),
    LEGACYHTML5(true, false, false),
    XHTML(true, false, false),
    VALIDXHTML(true, false, false),
    VALIDXML(false, true, false);

    private static Logger logger;
    private final boolean html;
    private final boolean xml;
    private final boolean text;
    private final boolean caseSensitive;

    private TemplateMode(boolean html, boolean xml, boolean text) {
        this.html = html;
        this.xml = xml;
        this.text = text;
        this.caseSensitive = !this.html;
    }

    public boolean isMarkup() {
        return this.html || this.xml;
    }

    public boolean isText() {
        return this.text;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public static TemplateMode parse(String mode) {
        if (mode == null || mode.trim().length() == 0) {
            throw new IllegalArgumentException("Template mode cannot be null or empty");
        }
        if ("HTML".equalsIgnoreCase(mode)) {
            return HTML;
        }
        if ("XML".equalsIgnoreCase(mode)) {
            return XML;
        }
        if ("TEXT".equalsIgnoreCase(mode)) {
            return TEXT;
        }
        if ("JAVASCRIPT".equalsIgnoreCase(mode)) {
            return JAVASCRIPT;
        }
        if ("CSS".equalsIgnoreCase(mode)) {
            return CSS;
        }
        if ("RAW".equalsIgnoreCase(mode)) {
            return RAW;
        }
        if ("HTML5".equalsIgnoreCase(mode) || "XHTML".equalsIgnoreCase(mode) || "VALIDXHTML".equalsIgnoreCase(mode) || "LEGACYHTML5".equalsIgnoreCase(mode)) {
            logger.warn("[THYMELEAF][{}] Template Mode '{}' is deprecated. Using Template Mode '{}' instead.", new Object[]{TemplateEngine.threadIndex(), mode, HTML});
            return HTML;
        }
        if ("VALIDXML".equalsIgnoreCase(mode)) {
            logger.warn("[THYMELEAF][{}] Template Mode '{}' is deprecated. Using Template Mode '{}' instead.", new Object[]{TemplateEngine.threadIndex(), mode, XML});
            return XML;
        }
        logger.warn("[THYMELEAF][{}] Unknown Template Mode '{}'. Must be one of: 'HTML', 'XML', 'TEXT', 'JAVASCRIPT', 'CSS', 'RAW'. Using default Template Mode '{}'.", new Object[]{TemplateEngine.threadIndex(), mode, HTML});
        return HTML;
    }

    static {
        logger = LoggerFactory.getLogger(TemplateMode.class);
    }
}

