/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.templateparser.markup;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.ezlibs.shaded.org.attoparser.AbstractMarkupHandler;
import org.ezlibs.shaded.org.attoparser.IMarkupHandler;
import org.ezlibs.shaded.org.attoparser.IMarkupParser;
import org.ezlibs.shaded.org.attoparser.MarkupParser;
import org.ezlibs.shaded.org.attoparser.ParseException;
import org.ezlibs.shaded.org.attoparser.config.ParseConfiguration;
import org.ezlibs.shaded.org.attoparser.select.BlockSelectorMarkupHandler;
import org.ezlibs.shaded.org.attoparser.select.IMarkupSelectorReferenceResolver;
import org.ezlibs.shaded.org.attoparser.select.NodeSelectorMarkupHandler;
import org.ezlibs.shaded.org.thymeleaf.EngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateHandlerAdapterMarkupHandler;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateInputException;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.templateparser.ITemplateParser;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.InlinedOutputExpressionMarkupHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.TemplateFragmentMarkupReferenceResolver;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogic;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogicMarkupHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogicUtils;
import org.ezlibs.shaded.org.thymeleaf.templateparser.reader.ParserLevelCommentMarkupReader;
import org.ezlibs.shaded.org.thymeleaf.templateparser.reader.PrototypeOnlyCommentMarkupReader;
import org.ezlibs.shaded.org.thymeleaf.templateresource.ITemplateResource;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public abstract class AbstractMarkupTemplateParser
implements ITemplateParser {
    private final IMarkupParser parser;
    private final boolean html;

    protected AbstractMarkupTemplateParser(ParseConfiguration parseConfiguration, int bufferPoolSize, int bufferSize) {
        Validate.notNull(parseConfiguration, "Parse configuration cannot be null");
        this.parser = new MarkupParser(parseConfiguration, bufferPoolSize, bufferSize);
        this.html = parseConfiguration.getMode().equals((Object)ParseConfiguration.ParsingMode.HTML);
    }

    @Override
    public void parseStandalone(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource, TemplateMode templateMode, boolean useDecoupledLogic, ITemplateHandler handler) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull(resource, "Template Resource cannot be null");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        Validate.isTrue(templateMode.isMarkup(), "Template Mode has to be a markup template mode");
        Validate.notNull(handler, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, templateSelectors, resource, 0, 0, templateMode, useDecoupledLogic, handler);
    }

    @Override
    public void parseString(IEngineConfiguration configuration, String ownerTemplate, String template, int lineOffset, int colOffset, TemplateMode templateMode, ITemplateHandler handler) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(ownerTemplate, "Owner template cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Validate.isTrue(templateMode.isMarkup(), "Template Mode has to be a markup template mode");
        Validate.notNull(handler, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, null, null, lineOffset, colOffset, templateMode, false, handler);
    }

    private void parse(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource, int lineOffset, int colOffset, TemplateMode templateMode, boolean useDecoupledLogic, ITemplateHandler templateHandler) {
        if (templateMode == TemplateMode.HTML) {
            Validate.isTrue(this.html, "Parser is configured as XML, but HTML-mode template parsing is being requested");
        } else if (templateMode == TemplateMode.XML) {
            Validate.isTrue(!this.html, "Parser is configured as HTML, but XML-mode template parsing is being requested");
        } else {
            throw new IllegalArgumentException("Parser is configured as " + (this.html ? "HTML" : "XML") + " but an unsupported template mode has been specified: " + (Object)((Object)templateMode));
        }
        String templateName = resource != null ? template : ownerTemplate;
        try {
            String standardDialectPrefix;
            boolean selectBlock;
            DecoupledTemplateLogic decoupledTemplateLogic = useDecoupledLogic && resource != null ? DecoupledTemplateLogicUtils.computeDecoupledTemplateLogic(configuration, ownerTemplate, template, templateSelectors, resource, templateMode, this.parser) : null;
            AbstractMarkupHandler handler = new TemplateHandlerAdapterMarkupHandler(templateName, templateHandler, configuration.getElementDefinitions(), configuration.getAttributeDefinitions(), templateMode, lineOffset, colOffset);
            if (configuration instanceof EngineConfiguration && ((EngineConfiguration)configuration).isModelReshapeable(templateMode)) {
                handler = new InlinedOutputExpressionMarkupHandler(configuration, templateMode, configuration.getStandardDialectPrefix(), handler);
            }
            boolean injectAttributes = decoupledTemplateLogic != null && decoupledTemplateLogic.hasInjectedAttributes();
            boolean bl = selectBlock = templateSelectors != null && !templateSelectors.isEmpty();
            TemplateFragmentMarkupReferenceResolver referenceResolver = injectAttributes || selectBlock ? ((standardDialectPrefix = configuration.getStandardDialectPrefix()) != null ? TemplateFragmentMarkupReferenceResolver.forPrefix(this.html, standardDialectPrefix) : null) : null;
            if (selectBlock) {
                handler = new BlockSelectorMarkupHandler((IMarkupHandler)handler, templateSelectors.toArray(new String[templateSelectors.size()]), (IMarkupSelectorReferenceResolver)referenceResolver);
            }
            if (injectAttributes) {
                handler = new DecoupledTemplateLogicMarkupHandler(decoupledTemplateLogic, handler);
                Set<String> nodeSelectors = decoupledTemplateLogic.getAllInjectedAttributeSelectors();
                handler = new NodeSelectorMarkupHandler((IMarkupHandler)handler, (IMarkupHandler)handler, nodeSelectors.toArray(new String[nodeSelectors.size()]), (IMarkupSelectorReferenceResolver)referenceResolver);
            }
            Reader templateReader = resource != null ? resource.reader() : new StringReader(template);
            templateReader = new ParserLevelCommentMarkupReader(new PrototypeOnlyCommentMarkupReader(templateReader));
            this.parser.parse(templateReader, (IMarkupHandler)handler);
        }
        catch (IOException e) {
            String message = "An error happened during template parsing";
            throw new TemplateInputException("An error happened during template parsing", resource != null ? resource.getDescription() : template, e);
        }
        catch (ParseException e) {
            String message = "An error happened during template parsing";
            if (e.getLine() != null && e.getCol() != null) {
                throw new TemplateInputException("An error happened during template parsing", resource != null ? resource.getDescription() : template, e.getLine(), e.getCol(), e);
            }
            throw new TemplateInputException("An error happened during template parsing", resource != null ? resource.getDescription() : template, e);
        }
    }
}

