/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled;

import java.io.IOException;
import java.util.Set;
import org.ezlibs.shaded.org.attoparser.IMarkupHandler;
import org.ezlibs.shaded.org.attoparser.IMarkupParser;
import org.ezlibs.shaded.org.attoparser.ParseException;
import org.ezlibs.shaded.org.slf4j.Logger;
import org.ezlibs.shaded.org.slf4j.LoggerFactory;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogic;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogicBuilderMarkupHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.markup.decoupled.IDecoupledTemplateLogicResolver;
import org.ezlibs.shaded.org.thymeleaf.templateresource.ITemplateResource;
import org.ezlibs.shaded.org.thymeleaf.util.LoggingUtils;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class DecoupledTemplateLogicUtils {
    private static final Logger logger = LoggerFactory.getLogger(DecoupledTemplateLogicUtils.class);

    public static DecoupledTemplateLogic computeDecoupledTemplateLogic(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource, TemplateMode templateMode, IMarkupParser parser) throws IOException, ParseException {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull(resource, "Template Resource cannot be null");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver = configuration.getDecoupledTemplateLogicResolver();
        ITemplateResource decoupledResource = decoupledTemplateLogicResolver.resolveDecoupledTemplateLogic(configuration, ownerTemplate, template, templateSelectors, resource, templateMode);
        if (!decoupledResource.exists()) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Decoupled logic for template \"{}\" could not be resolved as relative resource \"{}\". This does not need to be an error, as templates may lack a corresponding decoupled logic file.", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(template), decoupledResource.getDescription());
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Decoupled logic for template \"{}\" has been resolved as relative resource \"{}\"", TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(template), decoupledResource.getDescription());
        }
        DecoupledTemplateLogicBuilderMarkupHandler decoupledMarkupHandler = new DecoupledTemplateLogicBuilderMarkupHandler(template, templateMode);
        parser.parse(decoupledResource.reader(), (IMarkupHandler)decoupledMarkupHandler);
        return decoupledMarkupHandler.getDecoupledTemplateLogic();
    }

    private DecoupledTemplateLogicUtils() {
    }
}

