/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.templateparser.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.ezlibs.shaded.org.thymeleaf.EngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.IEngineConfiguration;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateHandlerAdapterTextHandler;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateInputException;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.templateparser.ITemplateParser;
import org.ezlibs.shaded.org.thymeleaf.templateparser.reader.ParserLevelCommentTextReader;
import org.ezlibs.shaded.org.thymeleaf.templateparser.reader.PrototypeOnlyCommentTextReader;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.AbstractTextHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.ITextHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.InlinedOutputExpressionTextHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.TextParseException;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.TextParser;
import org.ezlibs.shaded.org.thymeleaf.templateresource.ITemplateResource;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public abstract class AbstractTextTemplateParser
implements ITemplateParser {
    private final TextParser parser;

    protected AbstractTextTemplateParser(int bufferPoolSize, int bufferSize, boolean processCommentsAndLiterals, boolean standardDialectPresent) {
        this.parser = new TextParser(bufferPoolSize, bufferSize, processCommentsAndLiterals, standardDialectPresent);
    }

    @Override
    public void parseStandalone(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource, TemplateMode templateMode, boolean useDecoupledLogic, ITemplateHandler handler) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull(resource, "Template Resource cannot be null");
        Validate.isTrue(templateSelectors == null || templateSelectors.isEmpty(), "Template selectors cannot be specified for a template using a TEXT template mode: template insertion operations must be always performed on whole template files, not fragments");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        Validate.isTrue(templateMode.isText(), "Template Mode has to be a text template mode");
        Validate.isTrue(!useDecoupledLogic, "Cannot use decoupled logic in template mode " + (Object)((Object)templateMode));
        Validate.notNull(handler, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, templateSelectors, resource, 0, 0, templateMode, handler);
    }

    @Override
    public void parseString(IEngineConfiguration configuration, String ownerTemplate, String template, int lineOffset, int colOffset, TemplateMode templateMode, ITemplateHandler handler) {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(ownerTemplate, "Owner template cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        Validate.isTrue(templateMode.isText(), "Template Mode has to be a text template mode");
        Validate.notNull(handler, "Template Handler cannot be null");
        this.parse(configuration, ownerTemplate, template, null, null, lineOffset, colOffset, templateMode, handler);
    }

    private void parse(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource, int lineOffset, int colOffset, TemplateMode templateMode, ITemplateHandler templateHandler) {
        String templateName = resource != null ? template : ownerTemplate;
        try {
            AbstractTextHandler handler = new TemplateHandlerAdapterTextHandler(templateName, templateHandler, configuration.getElementDefinitions(), configuration.getAttributeDefinitions(), templateMode, lineOffset, colOffset);
            if (configuration instanceof EngineConfiguration && ((EngineConfiguration)configuration).isModelReshapeable(templateMode)) {
                handler = new InlinedOutputExpressionTextHandler(configuration, templateMode, configuration.getStandardDialectPrefix(), handler);
            }
            Reader templateReader = resource != null ? resource.reader() : new StringReader(template);
            templateReader = templateMode == TemplateMode.TEXT ? new ParserLevelCommentTextReader(templateReader) : new ParserLevelCommentTextReader(new PrototypeOnlyCommentTextReader(templateReader));
            this.parser.parse(templateReader, (ITextHandler)handler);
        }
        catch (IOException e) {
            String message = "An error happened during template parsing";
            throw new TemplateInputException("An error happened during template parsing", resource != null ? resource.getDescription() : template, e);
        }
        catch (TextParseException e) {
            String message = "An error happened during template parsing";
            if (e.getLine() != null && e.getCol() != null) {
                throw new TemplateInputException("An error happened during template parsing", resource != null ? resource.getDescription() : template, e.getLine(), e.getCol(), e);
            }
            throw new TemplateInputException("An error happened during template parsing", resource != null ? resource.getDescription() : template, e);
        }
    }
}

