/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.util;

import java.io.IOException;
import java.io.Writer;

public final class FastStringWriter
extends Writer {
    private final StringBuilder builder;

    public FastStringWriter() {
        this.builder = new StringBuilder();
    }

    public FastStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.builder = new StringBuilder(initialSize);
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(String str) {
        this.builder.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.builder.append(str, off, off + len);
    }

    @Override
    public void write(char[] cbuf) {
        this.builder.append(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.builder.append(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.builder.toString();
    }
}

