/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.ezjooq;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import org.ezlibs.ezjooq.EntityRepresentation;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;

final class EntityConverter {
    private EntityConverter() {
    }

    static EntityRepresentation convert(Object entity) {
        Table<Record> table = EntityConverter.getTable(entity.getClass());
        java.lang.reflect.Field[] entityFields = entity.getClass().getDeclaredFields();
        ArrayList<java.lang.reflect.Field> validFields = new ArrayList<java.lang.reflect.Field>();
        Field[] columns = EntityConverter.getAllColumnsAndFields(entityFields, validFields).toArray(new Field[0]);
        Object[] values = EntityConverter.getValues(entity, validFields);
        return new EntityRepresentation(table, columns, values);
    }

    static Table<Record> getTable(Class<?> type) {
        Annotation[] annotations = type.getDeclaredAnnotations();
        String tableName = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof javax.persistence.Table)) continue;
            javax.persistence.Table tableAnnotation = (javax.persistence.Table)annotation;
            tableName = EntityConverter.stripPackage(tableAnnotation.name().isEmpty() ? type.getName() : tableAnnotation.name());
            break;
        }
        return tableName != null ? DSL.table((String)tableName.toLowerCase()) : null;
    }

    private static Object[] getValues(Object entity, List<java.lang.reflect.Field> fields) {
        Object[] values = new Object[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            try {
                values[i] = fields.get(i).get(entity);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return values;
    }

    private static List<Field<?>> getAllColumnsAndFields(java.lang.reflect.Field[] fields, List<java.lang.reflect.Field> validFields) {
        ArrayList columns = new ArrayList();
        for (java.lang.reflect.Field field : fields) {
            Field<?> column = EntityConverter.getColumn(field);
            if (column == null) continue;
            field.setAccessible(true);
            columns.add(column);
            validFields.add(field);
        }
        return columns;
    }

    private static Field<?> getColumn(java.lang.reflect.Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        String columnName = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Column)) continue;
            Column columnAnnotation = (Column)annotation;
            columnName = columnAnnotation.name().isEmpty() ? field.getName() : columnAnnotation.name();
            break;
        }
        return columnName != null ? DSL.field(columnName) : null;
    }

    private static String stripPackage(String tableName) {
        int index = tableName.lastIndexOf(".");
        if (index == -1) {
            return tableName;
        }
        return tableName.substring(index + 1);
    }
}

