/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.ezjooq;

import java.util.List;
import org.ezlibs.ezjooq.CrudRepository;
import org.ezlibs.ezjooq.EntityConverter;
import org.ezlibs.ezjooq.EntityRepresentation;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.impl.DSL;

public class PojoRepository<E>
implements CrudRepository<E> {
    private final DSLContext db;
    private final Class<E> type;

    public PojoRepository(DSLContext db, Class<E> type) {
        this.db = db;
        this.type = type;
    }

    @Override
    public boolean create(E entity) {
        EntityRepresentation converted = EntityConverter.convert(entity);
        return this.db.insertInto(converted.getTable()).columns(converted.getFields()).values(converted.getValues()).execute() > 0;
    }

    @Override
    public void createMany(List<E> entities) {
        this.db.transaction(c -> entities.forEach(e -> {
            EntityRepresentation converted = EntityConverter.convert(e);
            c.dsl().insertInto(converted.getTable()).columns(converted.getFields()).values(converted.getValues()).execute();
        }));
    }

    @Override
    public List<E> readAll() {
        return this.db.select(new SelectFieldOrAsterisk[0]).from(EntityConverter.getTable(this.type)).fetch().into(this.type);
    }

    @Override
    public List<E> readAllWhere(Condition condition) {
        return this.db.select(new SelectFieldOrAsterisk[0]).from(EntityConverter.getTable(this.type)).where(condition).fetch().into(this.type);
    }

    @Override
    public E readOneWhere(Condition condition) {
        Record record = this.db.select(new SelectFieldOrAsterisk[0]).from(EntityConverter.getTable(this.type)).where(condition).limit(1).fetchOne();
        return (E)(record != null ? record.into(this.type) : null);
    }

    @Override
    public boolean updateWhere(E entity, Condition condition) {
        EntityRepresentation converted = EntityConverter.convert(entity);
        return this.db.update(converted.getTable()).set(converted.getEntityMap()).where(condition).execute() > 0;
    }

    @Override
    public boolean delete(E entity) {
        EntityRepresentation converted = EntityConverter.convert(entity);
        return this.db.delete(converted.getTable()).where(DSL.condition(converted.getEntityMap())).execute() > 0;
    }
}

