/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.ezmail;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.ezlibs.ezmail.Email;
import org.ezlibs.shaded.javax.activation.DataHandler;
import org.ezlibs.shaded.javax.activation.DataSource;

public final class EmailSender {
    private static final Properties PROPERTIES = System.getProperties();
    private static String sender;
    private static String senderAccount;
    private static String accountPassword;
    private static boolean configured;

    public static void configure(String smtpHost, int smtpPort, boolean useTls, String account, String password, String name) {
        PROPERTIES.put("mail.smtp.host", smtpHost);
        PROPERTIES.put("mail.smtp.port", (Object)smtpPort);
        PROPERTIES.put("mail.smtp.starttls.enable", (Object)useTls);
        PROPERTIES.put("mail.smtp.starttls.required", (Object)useTls);
        PROPERTIES.put("mail.smtp.auth", (Object)true);
        senderAccount = account;
        accountPassword = password;
        sender = name + "<" + senderAccount + ">";
        configured = true;
    }

    public static void send(Email email, String to) throws MessagingException, IllegalStateException {
        if (!configured) {
            throw new IllegalStateException("EmailSender has not been configured. Please call the `configure` method before calling any other methods.");
        }
        Message message = EmailSender.initializeMessage(email.getSubject(), to);
        MimeMultipart multipart = new MimeMultipart();
        BodyPart messagePart = EmailSender.createMessagePart(email.getHtmlContent());
        multipart.addBodyPart(messagePart);
        if (email.getImages() != null) {
            for (int i = 0; i < email.getImages().length; ++i) {
                BodyPart imagePart = EmailSender.createImagePart(email.getImages()[i], i);
                multipart.addBodyPart(imagePart);
            }
        }
        message.setContent((Multipart)multipart);
        Transport.send((Message)message);
    }

    private static Message initializeMessage(String subject, String recipient) throws MessagingException {
        Session session = EmailSender.getAuthenticatedSession();
        MimeMessage message = new MimeMessage(session);
        message.setSubject(subject);
        message.setFrom((Address)new InternetAddress(sender));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        return message;
    }

    private static BodyPart createImagePart(DataSource imageDataSource, int index) throws MessagingException {
        MimeBodyPart imagePart = new MimeBodyPart();
        imagePart.setDataHandler(new DataHandler(imageDataSource));
        imagePart.setHeader("Content-ID", "<image-" + index + ">");
        return imagePart;
    }

    private static BodyPart createMessagePart(String htmlContent) throws MessagingException {
        MimeBodyPart messagePart = new MimeBodyPart();
        messagePart.setContent((Object)htmlContent, "text/html");
        return messagePart;
    }

    private static Session getAuthenticatedSession() {
        return Session.getInstance((Properties)PROPERTIES, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(senderAccount, accountPassword);
            }
        });
    }

    static {
        configured = false;
    }

    private static final class SmtpProperties {
        static final String HOST = "mail.smtp.host";
        static final String PORT = "mail.smtp.port";
        static final String TLS_ENABLE = "mail.smtp.starttls.enable";
        static final String TLS_REQUIRED = "mail.smtp.starttls.required";
        static final String USE_AUTH = "mail.smtp.auth";

        private SmtpProperties() {
        }
    }
}

