/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.ezmail;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.mail.util.ByteArrayDataSource;
import org.ezlibs.ezmail.Email;
import org.ezlibs.ezmail.EmailSender;
import org.ezlibs.shaded.javax.activation.DataSource;
import org.ezlibs.shaded.org.thymeleaf.TemplateEngine;
import org.ezlibs.shaded.org.thymeleaf.context.Context;
import org.ezlibs.shaded.org.thymeleaf.context.IContext;

public abstract class TemplateEmail
implements Email {
    private static final TemplateEngine ENGINE = new TemplateEngine();

    protected static String populateHtmlTemplate(String template, Map<String, Object> varMap) {
        Context context = new Context();
        context.setVariables(varMap);
        return ENGINE.process(template, (IContext)context);
    }

    protected static DataSource loadImageDataSource(String resourcePath, String extension, String mimeType) {
        try {
            byte[] imageBytes = TemplateEmail.getImageResourceAsBytes(resourcePath, extension);
            return new ByteArrayDataSource(imageBytes, mimeType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String loadHtmlTemplate(String templatePath) throws IOException {
        if (!TemplateEmail.checkFileExtension(templatePath)) {
            throw new IOException("Invalid file type for HTML template. Only files ending in '.html' are supported.");
        }
        InputStream templateStream = TemplateEmail.class.getResourceAsStream(templatePath);
        if (templateStream == null) {
            throw new FileNotFoundException("File not found.");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(templateStream));
        return reader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    private static byte[] getImageResourceAsBytes(String resourcePath, String extension) throws IOException {
        InputStream imageStream = EmailSender.class.getResourceAsStream(resourcePath);
        BufferedImage image = ImageIO.read(imageStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, extension, outputStream);
        outputStream.flush();
        byte[] imageBytes = outputStream.toByteArray();
        outputStream.close();
        return imageBytes;
    }

    private static boolean checkFileExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        return (index > 0 ? path.substring(index + 1) : path.substring(index)).equals("html");
    }
}

