/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser;

import org.ezlibs.shaded.org.attoparser.HtmlVoidElement;
import org.ezlibs.shaded.org.attoparser.IMarkupHandler;
import org.ezlibs.shaded.org.attoparser.ParseException;
import org.ezlibs.shaded.org.attoparser.ParseStatus;

class HtmlVoidAutoOpenElement
extends HtmlVoidElement {
    private final char[][] autoOpenParents;
    private final char[][] autoOpenLimits;

    HtmlVoidAutoOpenElement(String name, String[] autoOpenParents, String[] autoOpenLimits) {
        super(name);
        char[][] autoOpenLimitsCharArray;
        if (autoOpenParents == null) {
            throw new IllegalArgumentException("The array of auto-open parents cannot be null");
        }
        char[][] autoOpenParentsCharArray = new char[autoOpenParents.length][];
        for (int i = 0; i < autoOpenParentsCharArray.length; ++i) {
            autoOpenParentsCharArray[i] = autoOpenParents[i].toCharArray();
        }
        if (autoOpenLimits != null) {
            autoOpenLimitsCharArray = new char[autoOpenLimits.length][];
            for (int i = 0; i < autoOpenLimitsCharArray.length; ++i) {
                autoOpenLimitsCharArray[i] = autoOpenLimits[i].toCharArray();
            }
        } else {
            autoOpenLimitsCharArray = null;
        }
        this.autoOpenParents = autoOpenParentsCharArray;
        this.autoOpenLimits = autoOpenLimitsCharArray;
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        status.setAvoidStacking(true);
        if (autoOpenEnabled && !status.isAutoOpenCloseDone()) {
            status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, false, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col, IMarkupHandler handler, ParseStatus status, boolean autoOpenEnabled, boolean autoCloseEnabled) throws ParseException {
        status.setAvoidStacking(true);
        if (autoOpenEnabled && status.isAutoOpenCloseDone()) {
            status.setAutoOpenRequired(this.autoOpenParents, this.autoOpenLimits);
            return;
        }
        handler.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }
}

