/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser.dom;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ezlibs.shaded.org.attoparser.AbstractMarkupHandler;
import org.ezlibs.shaded.org.attoparser.ParseException;
import org.ezlibs.shaded.org.attoparser.dom.CDATASection;
import org.ezlibs.shaded.org.attoparser.dom.Comment;
import org.ezlibs.shaded.org.attoparser.dom.DocType;
import org.ezlibs.shaded.org.attoparser.dom.Document;
import org.ezlibs.shaded.org.attoparser.dom.Element;
import org.ezlibs.shaded.org.attoparser.dom.INestableNode;
import org.ezlibs.shaded.org.attoparser.dom.ProcessingInstruction;
import org.ezlibs.shaded.org.attoparser.dom.StructureTextsRepository;
import org.ezlibs.shaded.org.attoparser.dom.Text;
import org.ezlibs.shaded.org.attoparser.dom.XmlDeclaration;

public final class DOMBuilderMarkupHandler
extends AbstractMarkupHandler {
    private final String documentName;
    private Document document = null;
    private boolean parsingFinished = false;
    private long parsingStartTimeNanos = -1L;
    private long parsingEndTimeNanos = -1L;
    private long parsingTotalTimeNanos = -1L;
    private INestableNode currentParent = null;
    private String currentElementName = null;
    private Map<String, String> currentElementAttributes = null;
    private int currentElementLine = -1;
    private int currentElementCol = -1;

    public DOMBuilderMarkupHandler() {
        this(null);
    }

    public DOMBuilderMarkupHandler(String documentName) {
        this.documentName = documentName == null ? String.valueOf(System.identityHashCode(this)) : documentName;
    }

    public Document getDocument() {
        return this.document;
    }

    public long getParsingStartTimeNanos() {
        return this.parsingStartTimeNanos;
    }

    public long getParsingEndTimeNanos() {
        return this.parsingEndTimeNanos;
    }

    public long getParsingTotalTimeNanos() {
        return this.parsingTotalTimeNanos;
    }

    public boolean isParsingFinished() {
        return this.parsingFinished;
    }

    @Override
    public void handleDocumentStart(long startTimeNanos, int line, int col) throws ParseException {
        this.document = new Document(this.documentName);
        this.parsingStartTimeNanos = startTimeNanos;
    }

    @Override
    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws ParseException {
        this.parsingEndTimeNanos = endTimeNanos;
        this.parsingTotalTimeNanos = totalTimeNanos;
        this.parsingFinished = true;
    }

    @Override
    public void handleXmlDeclaration(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int versionOffset, int versionLen, int versionLine, int versionCol, int encodingOffset, int encodingLen, int encodingLine, int encodingCol, int standaloneOffset, int standaloneLen, int standaloneLine, int standaloneCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        String version = new String(buffer, versionOffset, versionLen);
        String encoding = encodingOffset > 0 ? new String(buffer, encodingOffset, encodingLen) : null;
        String standalone = standaloneOffset > 0 ? new String(buffer, standaloneOffset, standaloneLen) : null;
        XmlDeclaration xmlDeclaration = new XmlDeclaration(version, encoding, standalone);
        xmlDeclaration.setLine(line);
        xmlDeclaration.setLine(col);
        if (this.currentParent == null) {
            this.document.addChild(xmlDeclaration);
        } else {
            this.currentParent.addChild(xmlDeclaration);
        }
    }

    @Override
    public void handleDocType(char[] buffer, int keywordOffset, int keywordLen, int keywordLine, int keywordCol, int elementNameOffset, int elementNameLen, int elementNameLine, int elementNameCol, int typeOffset, int typeLen, int typeLine, int typeCol, int publicIdOffset, int publicIdLen, int publicIdLine, int publicIdCol, int systemIdOffset, int systemIdLen, int systemIdLine, int systemIdCol, int internalSubsetOffset, int internalSubsetLen, int internalSubsetLine, int internalSubsetCol, int outerOffset, int outerLen, int outerLine, int outerCol) throws ParseException {
        String elementName = new String(buffer, elementNameOffset, elementNameLen);
        String publicId = publicIdOffset <= 0 ? null : new String(buffer, publicIdOffset, publicIdLen);
        String systemId = systemIdOffset <= 0 ? null : new String(buffer, systemIdOffset, systemIdLen);
        String internalSubset = internalSubsetOffset <= 0 ? null : new String(buffer, internalSubsetOffset, internalSubsetLen);
        DocType docType = new DocType(elementName, publicId, systemId, internalSubset);
        docType.setLine(outerLine);
        docType.setLine(outerCol);
        if (this.currentParent == null) {
            this.document.addChild(docType);
        } else {
            this.currentParent.addChild(docType);
        }
    }

    @Override
    public void handleCDATASection(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        CDATASection cdataSection = new CDATASection(new String(buffer, contentOffset, contentLen));
        cdataSection.setLine(line);
        cdataSection.setLine(col);
        if (this.currentParent == null) {
            this.document.addChild(cdataSection);
        } else {
            this.currentParent.addChild(cdataSection);
        }
    }

    @Override
    public void handleComment(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws ParseException {
        Comment comment = new Comment(new String(buffer, contentOffset, contentLen));
        comment.setLine(line);
        comment.setLine(col);
        if (this.currentParent == null) {
            this.document.addChild(comment);
        } else {
            this.currentParent.addChild(comment);
        }
    }

    @Override
    public void handleText(char[] buffer, int offset, int len, int line, int col) throws ParseException {
        Text text = new Text(new String(buffer, offset, len));
        text.setLine(line);
        text.setLine(col);
        if (this.currentParent == null) {
            this.document.addChild(text);
        } else {
            this.currentParent.addChild(text);
        }
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        this.currentElementName = StructureTextsRepository.getStructureName(buffer, nameOffset, nameLen);
        this.currentElementAttributes = null;
        this.currentElementLine = line;
        this.currentElementCol = col;
    }

    @Override
    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws ParseException {
        Element element = new Element(this.currentElementName);
        element.addAttributes(this.currentElementAttributes);
        element.setLine(this.currentElementLine);
        element.setLine(this.currentElementCol);
        if (this.currentParent == null) {
            this.document.addChild(element);
        } else {
            this.currentParent.addChild(element);
        }
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.currentElementName = StructureTextsRepository.getStructureName(buffer, nameOffset, nameLen);
        this.currentElementAttributes = null;
        this.currentElementLine = line;
        this.currentElementCol = col;
    }

    @Override
    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        Element element = new Element(this.currentElementName);
        element.addAttributes(this.currentElementAttributes);
        element.setLine(this.currentElementLine);
        element.setLine(this.currentElementCol);
        if (this.currentParent == null) {
            this.document.addChild(element);
        } else {
            this.currentParent.addChild(element);
        }
        this.currentParent = element;
    }

    @Override
    public void handleAutoOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.currentElementName = StructureTextsRepository.getStructureName(buffer, nameOffset, nameLen);
        this.currentElementAttributes = null;
        this.currentElementLine = line;
        this.currentElementCol = col;
    }

    @Override
    public void handleAutoOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        Element element = new Element(this.currentElementName);
        element.addAttributes(this.currentElementAttributes);
        element.setLine(this.currentElementLine);
        element.setLine(this.currentElementCol);
        if (this.currentParent == null) {
            this.document.addChild(element);
        } else {
            this.currentParent.addChild(element);
        }
        this.currentParent = element;
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.currentElementName = StructureTextsRepository.getStructureName(buffer, nameOffset, nameLen);
        this.currentElementAttributes = null;
        this.currentElementLine = line;
        this.currentElementCol = col;
    }

    @Override
    public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.currentParent = this.currentParent.getParent();
    }

    @Override
    public void handleAutoCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.currentElementName = StructureTextsRepository.getStructureName(buffer, nameOffset, nameLen);
        this.currentElementAttributes = null;
        this.currentElementLine = line;
        this.currentElementCol = col;
    }

    @Override
    public void handleAutoCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
        this.currentParent = this.currentParent.getParent();
    }

    @Override
    public void handleUnmatchedCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws ParseException {
    }

    @Override
    public void handleUnmatchedCloseElementEnd(char[] buffer, int offset, int len, int line, int col) throws ParseException {
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws ParseException {
        String attributeValue;
        String attributeName = StructureTextsRepository.getStructureName(buffer, nameOffset, nameLen);
        String string = attributeValue = valueContentLen <= 0 ? "" : new String(buffer, valueContentOffset, valueContentLen);
        if (this.currentElementAttributes == null) {
            this.currentElementAttributes = new LinkedHashMap<String, String>(5, 1.0f);
        }
        this.currentElementAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void handleInnerWhiteSpace(char[] buffer, int offset, int len, int line, int col) throws ParseException {
    }

    @Override
    public void handleProcessingInstruction(char[] buffer, int targetOffset, int targetLen, int targetLine, int targetCol, int contentOffset, int contentLen, int contentLine, int contentCol, int outerOffset, int outerLen, int line, int col) throws ParseException {
        String target = new String(buffer, targetOffset, targetLen);
        String content = contentOffset <= 0 ? null : new String(buffer, contentOffset, contentLen);
        ProcessingInstruction processingInstruction = new ProcessingInstruction(target, content);
        processingInstruction.setLine(line);
        processingInstruction.setLine(col);
        if (this.currentParent == null) {
            this.document.addChild(processingInstruction);
        } else {
            this.currentParent.addChild(processingInstruction);
        }
    }
}

