/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser.dom;

import java.io.Reader;
import org.ezlibs.shaded.org.attoparser.IMarkupHandler;
import org.ezlibs.shaded.org.attoparser.MarkupParser;
import org.ezlibs.shaded.org.attoparser.ParseException;
import org.ezlibs.shaded.org.attoparser.config.ParseConfiguration;
import org.ezlibs.shaded.org.attoparser.dom.DOMBuilderMarkupHandler;
import org.ezlibs.shaded.org.attoparser.dom.Document;
import org.ezlibs.shaded.org.attoparser.dom.IDOMMarkupParser;

public final class DOMMarkupParser
implements IDOMMarkupParser {
    private final MarkupParser markupParser;

    public DOMMarkupParser(ParseConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.markupParser = new MarkupParser(configuration);
    }

    @Override
    public Document parse(String document) throws ParseException {
        return this.parse(null, document);
    }

    @Override
    public Document parse(char[] document) throws ParseException {
        return this.parse(null, document);
    }

    @Override
    public Document parse(char[] document, int offset, int len) throws ParseException {
        return this.parse(null, document, offset, len);
    }

    @Override
    public Document parse(Reader reader) throws ParseException {
        return this.parse(null, reader);
    }

    @Override
    public Document parse(String documentName, String document) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(document, (IMarkupHandler)domHandler);
        return domHandler.getDocument();
    }

    @Override
    public Document parse(String documentName, char[] document) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(document, (IMarkupHandler)domHandler);
        return domHandler.getDocument();
    }

    @Override
    public Document parse(String documentName, char[] document, int offset, int len) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(document, offset, len, domHandler);
        return domHandler.getDocument();
    }

    @Override
    public Document parse(String documentName, Reader reader) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(reader, (IMarkupHandler)domHandler);
        return domHandler.getDocument();
    }
}

