/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.attoparser.dom;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.ezlibs.shaded.org.attoparser.dom.CDATASection;
import org.ezlibs.shaded.org.attoparser.dom.Comment;
import org.ezlibs.shaded.org.attoparser.dom.DocType;
import org.ezlibs.shaded.org.attoparser.dom.Document;
import org.ezlibs.shaded.org.attoparser.dom.Element;
import org.ezlibs.shaded.org.attoparser.dom.INode;
import org.ezlibs.shaded.org.attoparser.dom.ProcessingInstruction;
import org.ezlibs.shaded.org.attoparser.dom.Text;
import org.ezlibs.shaded.org.attoparser.dom.XmlDeclaration;

public final class DOMWriter {
    public static void write(INode node, Writer writer) throws IOException {
        if (node == null) {
            return;
        }
        if (node instanceof Text) {
            DOMWriter.writeText((Text)node, writer);
            return;
        }
        if (node instanceof Element) {
            DOMWriter.writeElement((Element)node, writer);
            return;
        }
        if (node instanceof Comment) {
            DOMWriter.writeComment((Comment)node, writer);
            return;
        }
        if (node instanceof CDATASection) {
            DOMWriter.writeCDATASection((CDATASection)node, writer);
            return;
        }
        if (node instanceof DocType) {
            DOMWriter.writeDocType((DocType)node, writer);
            return;
        }
        if (node instanceof Document) {
            DOMWriter.writeDocument((Document)node, writer);
            return;
        }
        if (node instanceof XmlDeclaration) {
            DOMWriter.writeXmlDeclaration((XmlDeclaration)node, writer);
            return;
        }
        if (node instanceof ProcessingInstruction) {
            DOMWriter.writeProcessingInstruction((ProcessingInstruction)node, writer);
            return;
        }
    }

    public static void writeCDATASection(CDATASection cdataSection, Writer writer) throws IOException {
        writer.write("<![CDATA[");
        writer.write(cdataSection.getContent());
        writer.write("]]>");
    }

    public static void writeComment(Comment comment, Writer writer) throws IOException {
        writer.write("<!--");
        writer.write(comment.getContent());
        writer.write("-->");
    }

    public static void writeDocType(DocType docType, Writer writer) throws IOException {
        writer.write("<!DOCTYPE ");
        writer.write(docType.getRootElementName());
        String publicId = docType.getPublicId();
        String systemId = docType.getSystemId();
        String internalSubset = docType.getInternalSubset();
        if (publicId != null || systemId != null) {
            String type = publicId == null ? "SYSTEM" : "PUBLIC";
            writer.write(32);
            writer.write(type);
            if (publicId != null) {
                writer.write(32);
                writer.write(34);
                writer.write(publicId);
                writer.write(34);
            }
            if (systemId != null) {
                writer.write(32);
                writer.write(34);
                writer.write(systemId);
                writer.write(34);
            }
        }
        if (internalSubset != null) {
            writer.write(32);
            writer.write(91);
            writer.write(internalSubset);
            writer.write(93);
        }
        writer.write(62);
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        if (!document.hasChildren()) {
            return;
        }
        for (INode child : document.getChildren()) {
            DOMWriter.write(child, writer);
        }
    }

    public static void writeElement(Element element, Writer writer) throws IOException {
        writer.write(60);
        writer.write(element.getElementName());
        if (element.hasAttributes()) {
            Map<String, String> attributes = element.getAttributeMap();
            for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
                writer.write(32);
                writer.write(attributeEntry.getKey());
                writer.write(61);
                writer.write(34);
                writer.write(attributeEntry.getValue());
                writer.write(34);
            }
        }
        if (!element.hasChildren()) {
            writer.write(47);
            writer.write(62);
            return;
        }
        writer.write(62);
        for (INode child : element.getChildren()) {
            DOMWriter.write(child, writer);
        }
        writer.write(60);
        writer.write(47);
        writer.write(element.getElementName());
        writer.write(62);
    }

    public static void writeProcessingInstruction(ProcessingInstruction processingInstruction, Writer writer) throws IOException {
        writer.write(60);
        writer.write(63);
        writer.write(processingInstruction.getTarget());
        String content = processingInstruction.getContent();
        if (content != null) {
            writer.write(32);
            writer.write(content);
        }
        writer.write(63);
        writer.write(62);
    }

    public static void writeText(Text text, Writer writer) throws IOException {
        DOMWriter.validateNotNull(text, "Text node cannot be null");
        DOMWriter.validateNotNull(writer, "Writer cannot be null");
        writer.write(text.getContent());
    }

    public static void writeXmlDeclaration(XmlDeclaration xmlDeclaration, Writer writer) throws IOException {
        String standalone;
        DOMWriter.validateNotNull(xmlDeclaration, "XML declaration cannot be null");
        DOMWriter.validateNotNull(writer, "Writer cannot be null");
        writer.write("<?xml version=\"");
        writer.write(xmlDeclaration.getVersion());
        writer.write(34);
        String encoding = xmlDeclaration.getEncoding();
        if (encoding != null) {
            writer.write(" encoding=\"");
            writer.write(encoding);
            writer.write(34);
        }
        if ((standalone = xmlDeclaration.getStandalone()) != null) {
            writer.write(" standalone=\"");
            writer.write(standalone);
            writer.write(34);
        }
        writer.write(63);
        writer.write(62);
    }

    private static void validateNotNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private DOMWriter() {
    }
}

