/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf;

import org.ezlibs.shaded.org.thymeleaf.dialect.IDialect;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class DialectConfiguration {
    private final boolean prefixSpecified;
    private final String prefix;
    private final IDialect dialect;

    public DialectConfiguration(IDialect dialect) {
        Validate.notNull(dialect, "Dialect cannot be null");
        this.prefixSpecified = false;
        this.prefix = null;
        this.dialect = dialect;
    }

    public DialectConfiguration(String prefix, IDialect dialect) {
        Validate.notNull(dialect, "Dialect cannot be null");
        this.prefixSpecified = true;
        this.prefix = prefix;
        this.dialect = dialect;
    }

    public IDialect getDialect() {
        return this.dialect;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isPrefixSpecified() {
        return this.prefixSpecified;
    }
}

