/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf;

import java.util.Properties;
import org.ezlibs.shaded.org.thymeleaf.util.ClassLoaderUtils;
import org.ezlibs.shaded.org.thymeleaf.util.VersionUtils;

public final class Thymeleaf {
    private static final String STABLE_RELEASE_QUALIFIER = "RELEASE";
    public static final String VERSION;
    public static final String BUILD_TIMESTAMP;
    public static final int VERSION_MAJOR;
    public static final int VERSION_MINOR;
    public static final int VERSION_BUILD;
    public static final String VERSION_TYPE;
    private static final VersionUtils.VersionSpec VERSION_SPEC;

    public static String getVersion() {
        return VERSION_SPEC.getVersion();
    }

    public static String getBuildTimestamp() {
        return VERSION_SPEC.getBuildTimestamp();
    }

    public static int getVersionMajor() {
        return VERSION_SPEC.getMajor();
    }

    public static int getVersionMinor() {
        return VERSION_SPEC.getMinor();
    }

    public static int getVersionPatch() {
        return VERSION_SPEC.getPatch();
    }

    public static String getVersionQualifier() {
        return VERSION_SPEC.getQualifier();
    }

    public static boolean isVersionStableRelease() {
        return STABLE_RELEASE_QUALIFIER.equals(VERSION_SPEC.getQualifier());
    }

    private Thymeleaf() {
    }

    static {
        String version = null;
        String buildTimestamp = null;
        try {
            Properties properties = new Properties();
            properties.load(ClassLoaderUtils.loadResourceAsStream("org/ezlibs/shaded/org/thymeleaf/thymeleaf.properties"));
            version = properties.getProperty("version");
            buildTimestamp = properties.getProperty("build.date");
        }
        catch (Exception exception) {
            // empty catch block
        }
        VERSION_SPEC = VersionUtils.parseVersion(version, buildTimestamp);
        VERSION = VERSION_SPEC.getVersion();
        BUILD_TIMESTAMP = VERSION_SPEC.getBuildTimestamp();
        VERSION_MAJOR = VERSION_SPEC.getMajor();
        VERSION_MINOR = VERSION_SPEC.getMinor();
        VERSION_BUILD = VERSION_SPEC.getPatch();
        VERSION_TYPE = VERSION_SPEC.getQualifier();
    }
}

