/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.ezlibs.shaded.org.thymeleaf.engine.AbstractElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.Attribute;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.Attributes;
import org.ezlibs.shaded.org.thymeleaf.engine.ElementDefinition;
import org.ezlibs.shaded.org.thymeleaf.model.AttributeValueQuotes;
import org.ezlibs.shaded.org.thymeleaf.model.IAttribute;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.element.MatchingElementName;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.util.ProcessorComparators;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

abstract class AbstractProcessableElementTag
extends AbstractElementTag
implements IProcessableElementTag {
    private static final IElementProcessor[] EMPTY_ASSOCIATED_PROCESSORS = new IElementProcessor[0];
    final Attributes attributes;
    private volatile IElementProcessor[] associatedProcessors = null;

    AbstractProcessableElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes, boolean synthetic) {
        super(templateMode, elementDefinition, elementCompleteName, synthetic);
        this.attributes = attributes;
    }

    AbstractProcessableElementTag(TemplateMode templateMode, ElementDefinition elementDefinition, String elementCompleteName, Attributes attributes, boolean synthetic, String templateName, int line, int col) {
        super(templateMode, elementDefinition, elementCompleteName, synthetic, templateName, line, col);
        this.attributes = attributes;
    }

    @Override
    public final boolean hasAttribute(String completeName) {
        Validate.notNull(completeName, "Attribute name cannot be null");
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.hasAttribute(this.templateMode, completeName);
    }

    @Override
    public final boolean hasAttribute(String prefix, String name) {
        Validate.notNull(name, "Attribute name cannot be null");
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.hasAttribute(this.templateMode, prefix, name);
    }

    @Override
    public final boolean hasAttribute(AttributeName attributeName) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.hasAttribute(attributeName);
    }

    @Override
    public final IAttribute getAttribute(String completeName) {
        Validate.notNull(completeName, "Attribute name cannot be null");
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(this.templateMode, completeName);
    }

    @Override
    public final IAttribute getAttribute(String prefix, String name) {
        Validate.notNull(name, "Attribute name cannot be null");
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(this.templateMode, prefix, name);
    }

    @Override
    public final IAttribute getAttribute(AttributeName attributeName) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(attributeName);
    }

    @Override
    public final String getAttributeValue(String completeName) {
        Validate.notNull(completeName, "Attribute name cannot be null");
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute = this.attributes.getAttribute(this.templateMode, completeName);
        return attribute != null ? attribute.getValue() : null;
    }

    @Override
    public final String getAttributeValue(String prefix, String name) {
        Validate.notNull(name, "Attribute name cannot be null");
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute = this.attributes.getAttribute(this.templateMode, prefix, name);
        return attribute != null ? attribute.getValue() : null;
    }

    @Override
    public final String getAttributeValue(AttributeName attributeName) {
        Validate.notNull(attributeName, "Attribute name cannot be null");
        if (this.attributes == null) {
            return null;
        }
        Attribute attribute = this.attributes.getAttribute(attributeName);
        return attribute != null ? attribute.getValue() : null;
    }

    @Override
    public IAttribute[] getAllAttributes() {
        if (this.attributes == null) {
            return Attributes.EMPTY_ATTRIBUTE_ARRAY;
        }
        return this.attributes.getAllAttributes();
    }

    @Override
    public Map<String, String> getAttributeMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes.getAttributeMap();
    }

    IElementProcessor[] getAssociatedProcessors() {
        IElementProcessor[] p = this.associatedProcessors;
        if (p == null) {
            p = this.computeProcessors();
            this.associatedProcessors = p;
        }
        return p;
    }

    boolean hasAssociatedProcessors() {
        return this.getAssociatedProcessors().length > 0;
    }

    private IElementProcessor[] computeProcessors() {
        int associatedProcessorCount;
        int n = associatedProcessorCount = this.attributes != null ? this.attributes.getAssociatedProcessorCount() : 0;
        if (this.attributes == null || associatedProcessorCount == 0) {
            return this.elementDefinition.hasAssociatedProcessors ? this.elementDefinition.associatedProcessors : EMPTY_ASSOCIATED_PROCESSORS;
        }
        int elementProcessorCount = this.elementDefinition.hasAssociatedProcessors ? this.elementDefinition.associatedProcessors.length : 0;
        IElementProcessor[] processors = new IElementProcessor[elementProcessorCount + associatedProcessorCount];
        if (elementProcessorCount > 0) {
            System.arraycopy(this.elementDefinition.associatedProcessors, 0, processors, 0, elementProcessorCount);
        }
        int idx = elementProcessorCount;
        int n2 = this.attributes.attributes.length;
        while (n2-- != 0) {
            if (!this.attributes.attributes[n2].definition.hasAssociatedProcessors) continue;
            IElementProcessor[] attributeAssociatedProcessors = this.attributes.attributes[n2].definition.associatedProcessors;
            for (int i = 0; i < attributeAssociatedProcessors.length; ++i) {
                MatchingElementName matchingElementName = attributeAssociatedProcessors[i].getMatchingElementName();
                if (matchingElementName != null && !matchingElementName.matches(this.elementDefinition.elementName)) continue;
                processors[idx++] = attributeAssociatedProcessors[i];
            }
        }
        if (idx < processors.length) {
            processors = Arrays.copyOf(processors, idx);
        }
        if (processors.length > 1) {
            Arrays.sort(processors, ProcessorComparators.PROCESSOR_COMPARATOR);
        }
        return processors;
    }

    abstract AbstractProcessableElementTag setAttribute(AttributeDefinitions var1, AttributeDefinition var2, String var3, String var4, AttributeValueQuotes var5);

    abstract AbstractProcessableElementTag replaceAttribute(AttributeDefinitions var1, AttributeName var2, AttributeDefinition var3, String var4, String var5, AttributeValueQuotes var6);

    abstract AbstractProcessableElementTag removeAttribute(String var1, String var2);

    abstract AbstractProcessableElementTag removeAttribute(String var1);

    abstract AbstractProcessableElementTag removeAttribute(AttributeName var1);
}

