/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.AttributeValueQuotes;
import org.ezlibs.shaded.org.thymeleaf.model.IAttribute;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.util.FastStringWriter;

final class Attribute
implements IAttribute {
    static final String DEFAULT_OPERATOR = "=";
    final AttributeDefinition definition;
    final String completeName;
    final String operator;
    final String value;
    final AttributeValueQuotes valueQuotes;
    final String templateName;
    final int line;
    final int col;
    private volatile IStandardExpression standardExpression = null;

    Attribute(AttributeDefinition definition, String completeName, String operator, String value, AttributeValueQuotes valueQuotes, String templateName, int line, int col) {
        this.definition = definition;
        this.completeName = completeName;
        this.value = value;
        this.operator = value == null ? null : (operator == null ? DEFAULT_OPERATOR : operator);
        this.valueQuotes = value == null ? null : (valueQuotes == null ? AttributeValueQuotes.DOUBLE : (valueQuotes == AttributeValueQuotes.NONE && value.length() == 0 ? AttributeValueQuotes.DOUBLE : valueQuotes));
        this.templateName = templateName;
        this.line = line;
        this.col = col;
    }

    @Override
    public AttributeDefinition getAttributeDefinition() {
        return this.definition;
    }

    @Override
    public String getAttributeCompleteName() {
        return this.completeName;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public AttributeValueQuotes getValueQuotes() {
        return this.valueQuotes;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public final boolean hasLocation() {
        return this.templateName != null && this.line != -1 && this.col != -1;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    IStandardExpression getCachedStandardExpression() {
        return this.standardExpression;
    }

    void setCachedStandardExpression(IStandardExpression standardExpression) {
        this.standardExpression = standardExpression;
    }

    Attribute modify(AttributeDefinition definition, String completeName, String value, AttributeValueQuotes valueQuotes) {
        return new Attribute(definition == null ? this.definition : definition, completeName == null ? this.completeName : completeName, this.operator, value, valueQuotes == null ? this.valueQuotes : valueQuotes, this.templateName, this.line, this.col);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.completeName);
        if (this.value != null) {
            writer.write(this.operator);
            if (this.valueQuotes == null) {
                writer.write(this.value);
            } else {
                switch (this.valueQuotes) {
                    case DOUBLE: {
                        writer.write(34);
                        writer.write(this.value);
                        writer.write(34);
                        break;
                    }
                    case SINGLE: {
                        writer.write(39);
                        writer.write(this.value);
                        writer.write(39);
                        break;
                    }
                    case NONE: {
                        writer.write(this.value);
                    }
                }
            }
        }
    }

    public String toString() {
        FastStringWriter stringWriter = new FastStringWriter();
        try {
            this.write(stringWriter);
        }
        catch (IOException e) {
            throw new TemplateProcessingException("Error computing attribute representation", e);
        }
        return ((Object)stringWriter).toString();
    }
}

