/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.ezlibs.shaded.org.thymeleaf.engine.AbstractTextualTemplateEvent;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.model.ICDATASection;
import org.ezlibs.shaded.org.thymeleaf.model.IModelVisitor;

final class CDATASection
extends AbstractTextualTemplateEvent
implements ICDATASection {
    static final String CDATA_PREFIX = "<![CDATA[";
    static final String CDATA_SUFFIX = "]]>";
    final String prefix;
    final String suffix;
    private volatile String computedCDATASectionStr = null;

    CDATASection(CharSequence content) {
        this(CDATA_PREFIX, content, CDATA_SUFFIX);
    }

    CDATASection(String prefix, CharSequence content, String suffix) {
        super(content);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    CDATASection(CharSequence content, String templateName, int line, int col) {
        this(CDATA_PREFIX, content, CDATA_SUFFIX, templateName, line, col);
    }

    CDATASection(String prefix, CharSequence content, String suffix, String templateName, int line, int col) {
        super(content, templateName, line, col);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String getCDATASection() {
        String c = this.computedCDATASectionStr;
        if (c == null) {
            this.computedCDATASectionStr = c = this.prefix + this.getContentText() + this.suffix;
        }
        return c;
    }

    @Override
    public String getContent() {
        return this.getContentText();
    }

    @Override
    public int length() {
        return this.prefix.length() + this.getContentLength() + this.suffix.length();
    }

    @Override
    public char charAt(int index) {
        if (index < this.prefix.length()) {
            return this.prefix.charAt(index);
        }
        int prefixedContentLen = this.prefix.length() + this.getContentLength();
        if (index >= prefixedContentLen) {
            return this.suffix.charAt(index - prefixedContentLen);
        }
        return this.charAtContent(index - this.prefix.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start >= this.prefix.length() && end < this.prefix.length() + this.getContentLength()) {
            return this.contentSubSequence(start - this.prefix.length(), end - this.prefix.length());
        }
        return this.getCDATASection().subSequence(start, end);
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.prefix);
        this.writeContent(writer);
        writer.write(this.suffix);
    }

    static CDATASection asEngineCDATASection(ICDATASection cdataSection) {
        if (cdataSection instanceof CDATASection) {
            return (CDATASection)cdataSection;
        }
        return new CDATASection(cdataSection.getContent(), cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleCDATASection(this);
    }

    @Override
    public String toString() {
        return this.getCDATASection();
    }
}

