/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.ezlibs.shaded.org.thymeleaf.engine.ElementName;
import org.ezlibs.shaded.org.thymeleaf.processor.element.IElementProcessor;
import org.ezlibs.shaded.org.thymeleaf.util.ProcessorComparators;

public abstract class ElementDefinition {
    final ElementName elementName;
    private final Set<IElementProcessor> associatedProcessorsSet;
    final IElementProcessor[] associatedProcessors;
    final boolean hasAssociatedProcessors;

    ElementDefinition(ElementName elementName, Set<IElementProcessor> associatedProcessors) {
        if (elementName == null) {
            throw new IllegalArgumentException("Element name cannot be null");
        }
        if (associatedProcessors == null) {
            throw new IllegalArgumentException("Associated processors cannot be null");
        }
        this.elementName = elementName;
        this.associatedProcessorsSet = Collections.unmodifiableSet(associatedProcessors);
        this.associatedProcessors = new IElementProcessor[this.associatedProcessorsSet.size()];
        int i = 0;
        for (IElementProcessor processor : this.associatedProcessorsSet) {
            this.associatedProcessors[i++] = processor;
        }
        Arrays.sort(this.associatedProcessors, ProcessorComparators.PROCESSOR_COMPARATOR);
        this.hasAssociatedProcessors = this.associatedProcessors.length > 0;
    }

    public final ElementName getElementName() {
        return this.elementName;
    }

    public boolean hasAssociatedProcessors() {
        return this.hasAssociatedProcessors;
    }

    public Set<IElementProcessor> getAssociatedProcessors() {
        return this.associatedProcessorsSet;
    }

    public final String toString() {
        return this.getElementName().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        ElementDefinition that = (ElementDefinition)o;
        return this.elementName.equals(that.elementName);
    }

    public int hashCode() {
        return this.elementName.hashCode();
    }
}

