/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.AbstractProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.Attribute;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeName;
import org.ezlibs.shaded.org.thymeleaf.engine.CDATASection;
import org.ezlibs.shaded.org.thymeleaf.engine.Comment;
import org.ezlibs.shaded.org.thymeleaf.engine.Text;
import org.ezlibs.shaded.org.thymeleaf.model.ICDATASection;
import org.ezlibs.shaded.org.thymeleaf.model.IComment;
import org.ezlibs.shaded.org.thymeleaf.model.IProcessableElementTag;
import org.ezlibs.shaded.org.thymeleaf.model.IText;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.FragmentExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpression;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.ezlibs.shaded.org.thymeleaf.standard.expression.StandardExpressions;

public final class EngineEventUtils {
    public static boolean isWhitespace(IText text) {
        if (text == null) {
            return false;
        }
        if (text instanceof Text) {
            return ((Text)text).isWhitespace();
        }
        return EngineEventUtils.computeWhitespace(text);
    }

    public static boolean isWhitespace(ICDATASection cdataSection) {
        if (cdataSection == null) {
            return false;
        }
        if (cdataSection instanceof CDATASection) {
            return ((CDATASection)cdataSection).isWhitespace();
        }
        return EngineEventUtils.computeWhitespace(cdataSection.getContent());
    }

    public static boolean isWhitespace(IComment comment) {
        if (comment == null) {
            return false;
        }
        if (comment instanceof Comment) {
            return ((Comment)comment).isWhitespace();
        }
        return EngineEventUtils.computeWhitespace(comment.getContent());
    }

    public static boolean isInlineable(IText text) {
        if (text == null) {
            return false;
        }
        if (text instanceof Text) {
            return ((Text)text).isInlineable();
        }
        return EngineEventUtils.computeInlineable(text);
    }

    public static boolean isInlineable(ICDATASection cdataSection) {
        if (cdataSection == null) {
            return false;
        }
        if (cdataSection instanceof CDATASection) {
            return ((CDATASection)cdataSection).isInlineable();
        }
        return EngineEventUtils.computeInlineable(cdataSection.getContent());
    }

    public static boolean isInlineable(IComment comment) {
        if (comment == null) {
            return false;
        }
        if (comment instanceof Comment) {
            return ((Comment)comment).isInlineable();
        }
        return EngineEventUtils.computeInlineable(comment.getContent());
    }

    private static boolean computeWhitespace(CharSequence text) {
        int n = text.length();
        if (n == 0) {
            return false;
        }
        while (n-- != 0) {
            char c = text.charAt(n);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean computeInlineable(CharSequence text) {
        int n = text.length();
        if (n == 0) {
            return false;
        }
        int c0 = 0;
        int inline = 0;
        while (n-- != 0) {
            char c1 = text.charAt(n);
            if (c1 == ']' && c0 == 93) {
                inline = 1;
            } else if (c1 == ')' && c0 == 93) {
                inline = 2;
            } else {
                if (inline == 1 && c1 == '[' && c0 == 91) {
                    return true;
                }
                if (inline == 2 && c1 == '[' && c0 == 40) {
                    return true;
                }
            }
            c0 = c1;
        }
        return false;
    }

    public static IStandardExpression computeAttributeExpression(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue) {
        if (!(tag instanceof AbstractProcessableElementTag)) {
            return EngineEventUtils.parseAttributeExpression(context, attributeValue);
        }
        AbstractProcessableElementTag processableElementTag = (AbstractProcessableElementTag)tag;
        Attribute attribute = (Attribute)processableElementTag.getAttribute(attributeName);
        IStandardExpression expression = attribute.getCachedStandardExpression();
        if (expression != null) {
            return expression;
        }
        expression = EngineEventUtils.parseAttributeExpression(context, attributeValue);
        if (expression != null && !(expression instanceof FragmentExpression) && attributeValue.indexOf(95) < 0) {
            attribute.setCachedStandardExpression(expression);
        }
        return expression;
    }

    private static IStandardExpression parseAttributeExpression(ITemplateContext context, String attributeValue) {
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
        return expressionParser.parseExpression(context, attributeValue);
    }

    private EngineEventUtils() {
    }
}

