/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateEnd;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateStart;
import org.ezlibs.shaded.org.thymeleaf.engine.Text;
import org.ezlibs.shaded.org.thymeleaf.templateparser.raw.IRawHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.raw.RawParseException;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class TemplateHandlerAdapterRawHandler
implements IRawHandler {
    private final String templateName;
    private final ITemplateHandler templateHandler;
    private final int lineOffset;
    private final int colOffset;

    public TemplateHandlerAdapterRawHandler(String templateName, ITemplateHandler templateHandler, int lineOffset, int colOffset) {
        Validate.notNull(templateHandler, "Template handler cannot be null");
        this.templateName = templateName;
        this.templateHandler = templateHandler;
        this.lineOffset = lineOffset > 0 ? lineOffset - 1 : lineOffset;
        this.colOffset = colOffset > 0 ? colOffset - 1 : colOffset;
    }

    @Override
    public void handleDocumentStart(long startTimeNanos, int line, int col) throws RawParseException {
        this.templateHandler.handleTemplateStart(TemplateStart.TEMPLATE_START_INSTANCE);
    }

    @Override
    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws RawParseException {
        this.templateHandler.handleTemplateEnd(TemplateEnd.TEMPLATE_END_INSTANCE);
    }

    @Override
    public void handleText(char[] buffer, int offset, int len, int line, int col) throws RawParseException {
        this.templateHandler.handleText(new Text(new String(buffer, offset, len), this.templateName, this.lineOffset + line, (line == 1 ? this.colOffset : 0) + col));
    }
}

