/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ezlibs.shaded.org.thymeleaf.engine.Attribute;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.AttributeDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.Attributes;
import org.ezlibs.shaded.org.thymeleaf.engine.CloseElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.ElementDefinition;
import org.ezlibs.shaded.org.thymeleaf.engine.ElementDefinitions;
import org.ezlibs.shaded.org.thymeleaf.engine.ITemplateHandler;
import org.ezlibs.shaded.org.thymeleaf.engine.OpenElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.StandaloneElementTag;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateEnd;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateStart;
import org.ezlibs.shaded.org.thymeleaf.engine.Text;
import org.ezlibs.shaded.org.thymeleaf.model.AttributeValueQuotes;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.AbstractTextHandler;
import org.ezlibs.shaded.org.thymeleaf.templateparser.text.TextParseException;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public final class TemplateHandlerAdapterTextHandler
extends AbstractTextHandler {
    private static final String[][] SYNTHETIC_INNER_WHITESPACES = new String[][]{new String[0], Attributes.DEFAULT_WHITE_SPACE_ARRAY, {" ", " "}, {" ", " ", " "}, {" ", " ", " ", " "}, {" ", " ", " ", " ", " "}};
    private final String templateName;
    private final ITemplateHandler templateHandler;
    private final ElementDefinitions elementDefinitions;
    private final AttributeDefinitions attributeDefinitions;
    private final TemplateMode templateMode;
    private final int lineOffset;
    private final int colOffset;
    private int currentElementLine = -1;
    private int currentElementCol = -1;
    private final List<Attribute> currentElementAttributes;

    public TemplateHandlerAdapterTextHandler(String templateName, ITemplateHandler templateHandler, ElementDefinitions elementDefinitions, AttributeDefinitions attributeDefinitions, TemplateMode templateMode, int lineOffset, int colOffset) {
        Validate.notNull(templateHandler, "Template handler cannot be null");
        Validate.notNull(elementDefinitions, "Element Definitions repository cannot be null");
        Validate.notNull(attributeDefinitions, "Attribute Definitions repository cannot be null");
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        this.templateName = templateName;
        this.templateHandler = templateHandler;
        this.elementDefinitions = elementDefinitions;
        this.attributeDefinitions = attributeDefinitions;
        this.templateMode = templateMode;
        this.lineOffset = lineOffset > 0 ? lineOffset - 1 : lineOffset;
        this.colOffset = colOffset > 0 ? colOffset - 1 : colOffset;
        this.currentElementAttributes = new ArrayList<Attribute>(10);
    }

    @Override
    public void handleDocumentStart(long startTimeNanos, int line, int col) throws TextParseException {
        this.templateHandler.handleTemplateStart(TemplateStart.TEMPLATE_START_INSTANCE);
    }

    @Override
    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws TextParseException {
        this.templateHandler.handleTemplateEnd(TemplateEnd.TEMPLATE_END_INSTANCE);
    }

    @Override
    public void handleText(char[] buffer, int offset, int len, int line, int col) throws TextParseException {
        this.templateHandler.handleText(new Text(new String(buffer, offset, len), this.templateName, this.lineOffset + line, (line == 1 ? this.colOffset : 0) + col));
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws TextParseException {
        this.currentElementLine = line;
        this.currentElementCol = col;
        this.currentElementAttributes.clear();
    }

    @Override
    public void handleStandaloneElementEnd(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws TextParseException {
        Attributes attributes;
        String elementCompleteName = new String(buffer, nameOffset, nameLen);
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementCompleteName);
        if (this.currentElementAttributes.isEmpty()) {
            attributes = null;
        } else {
            Object[] innerWhiteSpaces;
            Attribute[] attributesArr;
            Attribute[] attributeArray = attributesArr = this.currentElementAttributes.isEmpty() ? Attributes.EMPTY_ATTRIBUTE_ARRAY : this.currentElementAttributes.toArray(new Attribute[this.currentElementAttributes.size()]);
            if (attributesArr.length < SYNTHETIC_INNER_WHITESPACES.length) {
                innerWhiteSpaces = SYNTHETIC_INNER_WHITESPACES[attributesArr.length];
            } else {
                innerWhiteSpaces = new String[attributesArr.length];
                Arrays.fill(innerWhiteSpaces, " ");
            }
            attributes = new Attributes(attributesArr, (String[])innerWhiteSpaces);
        }
        this.templateHandler.handleStandaloneElement(new StandaloneElementTag(this.templateMode, elementDefinition, elementCompleteName, attributes, false, minimized, this.templateName, this.lineOffset + this.currentElementLine, (this.currentElementLine == 1 ? this.colOffset : 0) + this.currentElementCol));
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.currentElementLine = line;
        this.currentElementCol = col;
        this.currentElementAttributes.clear();
    }

    @Override
    public void handleOpenElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        Attributes attributes;
        String elementCompleteName = new String(buffer, nameOffset, nameLen);
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementCompleteName);
        if (this.currentElementAttributes.isEmpty()) {
            attributes = null;
        } else {
            Object[] innerWhiteSpaces;
            Attribute[] attributesArr;
            Attribute[] attributeArray = attributesArr = this.currentElementAttributes.isEmpty() ? Attributes.EMPTY_ATTRIBUTE_ARRAY : this.currentElementAttributes.toArray(new Attribute[this.currentElementAttributes.size()]);
            if (attributesArr.length < SYNTHETIC_INNER_WHITESPACES.length) {
                innerWhiteSpaces = SYNTHETIC_INNER_WHITESPACES[attributesArr.length];
            } else {
                innerWhiteSpaces = new String[attributesArr.length];
                Arrays.fill(innerWhiteSpaces, " ");
            }
            attributes = new Attributes(attributesArr, (String[])innerWhiteSpaces);
        }
        this.templateHandler.handleOpenElement(new OpenElementTag(this.templateMode, elementDefinition, elementCompleteName, attributes, false, this.templateName, this.lineOffset + this.currentElementLine, (this.currentElementLine == 1 ? this.colOffset : 0) + this.currentElementCol));
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.currentElementLine = line;
        this.currentElementCol = col;
        this.currentElementAttributes.clear();
    }

    @Override
    public void handleCloseElementEnd(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        String elementCompleteName = new String(buffer, nameOffset, nameLen);
        ElementDefinition elementDefinition = this.elementDefinitions.forName(this.templateMode, elementCompleteName);
        this.templateHandler.handleCloseElement(new CloseElementTag(this.templateMode, elementDefinition, elementCompleteName, null, false, false, this.templateName, this.lineOffset + this.currentElementLine, (this.currentElementLine == 1 ? this.colOffset : 0) + this.currentElementCol));
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws TextParseException {
        String value;
        String attributeName = new String(buffer, nameOffset, nameLen);
        AttributeDefinition attributeDefinition = this.attributeDefinitions.forName(this.templateMode, attributeName);
        String attributeOperator = operatorLen > 0 ? (operatorLen == 1 && buffer[operatorOffset] == '=' ? "=" : new String(buffer, operatorOffset, operatorLen)) : null;
        String string = value = attributeOperator != null ? new String(buffer, valueContentOffset, valueContentLen) : null;
        AttributeValueQuotes valueQuotes = value == null ? null : (valueOuterOffset == valueContentOffset ? AttributeValueQuotes.NONE : (buffer[valueOuterOffset] == '\"' ? AttributeValueQuotes.DOUBLE : (buffer[valueOuterOffset] == '\'' ? AttributeValueQuotes.SINGLE : AttributeValueQuotes.NONE)));
        Attribute newAttribute = new Attribute(attributeDefinition, attributeName, attributeOperator, value, valueQuotes, this.templateName, this.lineOffset + nameLine, (nameLine == 1 ? this.colOffset : 0) + nameCol);
        this.currentElementAttributes.add(newAttribute);
    }
}

