/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.messageresolver;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.engine.TemplateData;
import org.ezlibs.shaded.org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.ezlibs.shaded.org.thymeleaf.messageresolver.StandardMessageResolutionUtils;
import org.ezlibs.shaded.org.thymeleaf.templateresource.ITemplateResource;
import org.ezlibs.shaded.org.thymeleaf.util.Validate;

public class StandardMessageResolver
extends AbstractMessageResolver {
    private final ConcurrentHashMap<String, ConcurrentHashMap<Locale, Map<String, String>>> messagesByLocaleByTemplate = new ConcurrentHashMap(20, 0.9f, 2);
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<Locale, Map<String, String>>> messagesByLocaleByOrigin = new ConcurrentHashMap(20, 0.9f, 2);
    private final Properties defaultMessages = new Properties();

    public final Properties getDefaultMessages() {
        return this.defaultMessages;
    }

    public final void setDefaultMessages(Properties defaultMessages) {
        if (defaultMessages != null) {
            this.defaultMessages.putAll((Map<?, ?>)defaultMessages);
        }
    }

    public final void addDefaultMessage(String key, String value) {
        Validate.notNull(key, "Key for default message cannot be null");
        Validate.notNull(value, "Value for default message cannot be null");
        this.defaultMessages.put(key, value);
    }

    public final void clearDefaultMessages() {
        this.defaultMessages.clear();
    }

    @Override
    public final String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        return this.resolveMessage(context, origin, key, messageParameters, true, true, true);
    }

    public final String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters, boolean performTemplateBasedResolution, boolean performOriginBasedResolution, boolean performDefaultBasedResolution) {
        String message;
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(context.getLocale(), "Locale in context cannot be null");
        Validate.notNull(key, "Message key cannot be null");
        Locale locale = context.getLocale();
        if (performTemplateBasedResolution) {
            for (TemplateData templateData : context.getTemplateStack()) {
                String message2;
                Map<String, String> messagesForLocaleForTemplate;
                String template = templateData.getTemplate();
                ITemplateResource templateResource = templateData.getTemplateResource();
                boolean templateCacheable = templateData.getValidity().isCacheable();
                if (templateCacheable) {
                    ConcurrentHashMap<Locale, Map<String, String>> messagesByLocaleForTemplate = this.messagesByLocaleByTemplate.get(template);
                    if (messagesByLocaleForTemplate == null) {
                        this.messagesByLocaleByTemplate.putIfAbsent(template, new ConcurrentHashMap(4));
                        messagesByLocaleForTemplate = this.messagesByLocaleByTemplate.get(template);
                    }
                    if ((messagesForLocaleForTemplate = messagesByLocaleForTemplate.get(locale)) == null) {
                        messagesForLocaleForTemplate = this.resolveMessagesForTemplate(template, templateResource, locale);
                        if (messagesForLocaleForTemplate == null) {
                            messagesForLocaleForTemplate = Collections.emptyMap();
                        }
                        messagesByLocaleForTemplate.putIfAbsent(locale, messagesForLocaleForTemplate);
                        messagesForLocaleForTemplate = messagesByLocaleForTemplate.get(locale);
                    }
                } else {
                    messagesForLocaleForTemplate = this.resolveMessagesForTemplate(template, templateResource, locale);
                    if (messagesForLocaleForTemplate == null) {
                        messagesForLocaleForTemplate = Collections.emptyMap();
                    }
                }
                if ((message2 = messagesForLocaleForTemplate.get(key)) == null) continue;
                return this.formatMessage(locale, message2, messageParameters);
            }
        }
        if (performOriginBasedResolution && origin != null) {
            String message3;
            Map<String, String> messagesForLocaleForOrigin;
            ConcurrentHashMap<Locale, Map<String, String>> messagesByLocaleForOrigin = this.messagesByLocaleByOrigin.get(origin);
            if (messagesByLocaleForOrigin == null) {
                this.messagesByLocaleByOrigin.putIfAbsent(origin, new ConcurrentHashMap(4));
                messagesByLocaleForOrigin = this.messagesByLocaleByOrigin.get(origin);
            }
            if ((messagesForLocaleForOrigin = messagesByLocaleForOrigin.get(locale)) == null) {
                messagesForLocaleForOrigin = this.resolveMessagesForOrigin(origin, locale);
                if (messagesForLocaleForOrigin == null) {
                    messagesForLocaleForOrigin = Collections.emptyMap();
                }
                messagesByLocaleForOrigin.putIfAbsent(locale, messagesForLocaleForOrigin);
                messagesForLocaleForOrigin = messagesByLocaleForOrigin.get(locale);
            }
            if ((message3 = messagesForLocaleForOrigin.get(key)) != null) {
                return this.formatMessage(locale, message3, messageParameters);
            }
        }
        if (performDefaultBasedResolution && this.defaultMessages != null && (message = this.defaultMessages.getProperty(key)) != null) {
            return this.formatMessage(locale, message, messageParameters);
        }
        return null;
    }

    protected Map<String, String> resolveMessagesForTemplate(String template, ITemplateResource templateResource, Locale locale) {
        return StandardMessageResolutionUtils.resolveMessagesForTemplate(templateResource, locale);
    }

    protected Map<String, String> resolveMessagesForOrigin(Class<?> origin, Locale locale) {
        return StandardMessageResolutionUtils.resolveMessagesForOrigin(origin, locale);
    }

    protected String formatMessage(Locale locale, String message, Object[] messageParameters) {
        return StandardMessageResolutionUtils.formatMessage(locale, message, messageParameters);
    }

    @Override
    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin, String key, Object[] messageParameters) {
        Validate.notNull(key, "Message key cannot be null");
        if (context.getLocale() != null) {
            return "??" + key + "_" + context.getLocale().toString() + "??";
        }
        return "??" + key + "_??";
    }
}

