/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.processor.cdatasection;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.ICDATASection;
import org.ezlibs.shaded.org.thymeleaf.processor.AbstractProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.cdatasection.ICDATASectionProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.cdatasection.ICDATASectionStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractCDATASectionProcessor
extends AbstractProcessor
implements ICDATASectionProcessor {
    public AbstractCDATASectionProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, ICDATASection cdataSection, ICDATASectionStructureHandler structureHandler) {
        try {
            this.doProcess(context, cdataSection, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (cdataSection.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(cdataSection.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(cdataSection.getLine(), cdataSection.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, ICDATASection var2, ICDATASectionStructureHandler var3);
}

