/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.processor.comment;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.IComment;
import org.ezlibs.shaded.org.thymeleaf.processor.AbstractProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.comment.ICommentProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.comment.ICommentStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractCommentProcessor
extends AbstractProcessor
implements ICommentProcessor {
    public AbstractCommentProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IComment comment, ICommentStructureHandler structureHandler) {
        try {
            this.doProcess(context, comment, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (comment.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(comment.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(comment.getLine(), comment.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", comment.getTemplateName(), comment.getLine(), comment.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IComment var2, ICommentStructureHandler var3);
}

