/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.processor.doctype;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.IDocType;
import org.ezlibs.shaded.org.thymeleaf.processor.AbstractProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.doctype.IDocTypeProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.doctype.IDocTypeStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractDocTypeProcessor
extends AbstractProcessor
implements IDocTypeProcessor {
    public AbstractDocTypeProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void process(ITemplateContext context, IDocType docType, IDocTypeStructureHandler structureHandler) {
        try {
            this.doProcess(context, docType, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (docType.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(docType.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(docType.getLine(), docType.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", docType.getTemplateName(), docType.getLine(), docType.getCol(), e);
        }
    }

    protected abstract void doProcess(ITemplateContext var1, IDocType var2, IDocTypeStructureHandler var3);
}

