/*
 * Decompiled with CFR 0.152.
 */
package org.ezlibs.shaded.org.thymeleaf.processor.templateboundaries;

import org.ezlibs.shaded.org.thymeleaf.context.ITemplateContext;
import org.ezlibs.shaded.org.thymeleaf.exceptions.TemplateProcessingException;
import org.ezlibs.shaded.org.thymeleaf.model.ITemplateEnd;
import org.ezlibs.shaded.org.thymeleaf.model.ITemplateStart;
import org.ezlibs.shaded.org.thymeleaf.processor.AbstractProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.templateboundaries.ITemplateBoundariesProcessor;
import org.ezlibs.shaded.org.thymeleaf.processor.templateboundaries.ITemplateBoundariesStructureHandler;
import org.ezlibs.shaded.org.thymeleaf.templatemode.TemplateMode;

public abstract class AbstractTemplateBoundariesProcessor
extends AbstractProcessor
implements ITemplateBoundariesProcessor {
    public AbstractTemplateBoundariesProcessor(TemplateMode templateMode, int precedence) {
        super(templateMode, precedence);
    }

    @Override
    public final void processTemplateStart(ITemplateContext context, ITemplateStart templateStart, ITemplateBoundariesStructureHandler structureHandler) {
        try {
            this.doProcessTemplateStart(context, templateStart, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (templateStart.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(templateStart.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(templateStart.getLine(), templateStart.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", templateStart.getTemplateName(), templateStart.getLine(), templateStart.getCol(), e);
        }
    }

    @Override
    public final void processTemplateEnd(ITemplateContext context, ITemplateEnd templateEnd, ITemplateBoundariesStructureHandler structureHandler) {
        try {
            this.doProcessTemplateEnd(context, templateEnd, structureHandler);
        }
        catch (TemplateProcessingException e) {
            if (templateEnd.hasLocation()) {
                if (!e.hasTemplateName()) {
                    e.setTemplateName(templateEnd.getTemplateName());
                }
                if (!e.hasLineAndCol()) {
                    e.setLineAndCol(templateEnd.getLine(), templateEnd.getCol());
                }
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of processor '" + this.getClass().getName() + "'", templateEnd.getTemplateName(), templateEnd.getLine(), templateEnd.getCol(), e);
        }
    }

    public abstract void doProcessTemplateStart(ITemplateContext var1, ITemplateStart var2, ITemplateBoundariesStructureHandler var3);

    public abstract void doProcessTemplateEnd(ITemplateContext var1, ITemplateEnd var2, ITemplateBoundariesStructureHandler var3);
}

